/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.MultiIntervalCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class IntervalBarRenderer
extends BarRenderer
implements CategoryItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        if (categoryDataset instanceof MultiIntervalCategoryDataset) {
            MultiIntervalCategoryDataset multiIntervalCategoryDataset = (MultiIntervalCategoryDataset)categoryDataset;
            this.drawSubIntervals(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, multiIntervalCategoryDataset, n, n2);
        } else if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            this.drawInterval(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, intervalCategoryDataset, n, n2);
        }
    }

    protected void drawInterval(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, IntervalCategoryDataset intervalCategoryDataset, int n, int n2) {
        Object object;
        Object object2;
        double d;
        double d2;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d3 = 0.0;
        double d4 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        Number number = intervalCategoryDataset.getEndValue(n, n2);
        if (number == null) {
            return;
        }
        double d5 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge2);
        Number number2 = intervalCategoryDataset.getStartValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d6 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge2);
        if (d6 < d5) {
            d2 = d6;
            d6 = d5;
            d5 = d2;
            Number number3 = number2;
            number2 = number;
            number = number3;
        }
        d2 = this.getBarWidth();
        double d7 = Math.abs(d6 - d5);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d4 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
            if (n3 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n4 * (n3 - 1));
                d4 += (double)n * (this.getBarWidth() + d);
            } else {
                d4 += (double)n * this.getBarWidth();
            }
            d3 = d5;
            d7 = this.getBarWidth();
            d2 = Math.abs(d6 - d5);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
            if (n3 > 1) {
                d = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
                d3 += (double)n * (this.getBarWidth() + d);
            } else {
                d3 += (double)n * this.getBarWidth();
            }
            d4 = d5;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d2, d7);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, intervalCategoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, false);
        }
        if (this.getInfo() != null && (object = this.getInfo().getOwner().getEntityCollection()) != null) {
            String string2 = null;
            if (object2 != null) {
                string2 = object2.generateToolTip(intervalCategoryDataset, n, n2);
            }
            String string3 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string3 = this.getItemURLGenerator(n, n2).generateURL(intervalCategoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string2, string3, intervalCategoryDataset, n, intervalCategoryDataset.getColumnKey(n2), n2);
            object.addEntity(categoryItemEntity);
        }
    }

    private void drawSubIntervals(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, MultiIntervalCategoryDataset multiIntervalCategoryDataset, int n, int n2) {
        int n3 = multiIntervalCategoryDataset.getSubIntervalCount(n, n2);
        if (n3 == 0) {
            this.drawInterval(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, multiIntervalCategoryDataset, n, n2);
        }
        for (int i = 0; i < n3; ++i) {
            EntityCollection entityCollection;
            double d;
            double d2;
            RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
            Number number = multiIntervalCategoryDataset.getStartValue(n, n2, i);
            if (number == null) {
                return;
            }
            double d3 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge2);
            Number number2 = multiIntervalCategoryDataset.getEndValue(n, n2, i);
            if (number2 == null) {
                return;
            }
            double d4 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge2);
            if (d4 < d3) {
                d2 = d4;
                d4 = d3;
                d3 = d2;
            }
            d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
            int n4 = this.getRowCount();
            int n5 = this.getColumnCount();
            if (n4 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n5 * (n4 - 1));
                d2 += (double)n * (this.getBarWidth() + d);
            } else {
                d2 += (double)n * this.getBarWidth();
            }
            d = Math.abs(d4 - d3);
            double d5 = this.getBarWidth();
            Rectangle2D.Double double_ = null;
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(d3, d2, d, d5);
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d2, d3, d5, d);
            }
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if (this.getInfo() == null || (entityCollection = this.getInfo().getOwner().getEntityCollection()) == null) continue;
            String string2 = null;
            if (this.getItemLabelGenerator(n, n2) != null) {
                string2 = this.getItemLabelGenerator(n, n2).generateToolTip(multiIntervalCategoryDataset, n, n2);
            }
            String string3 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string3 = this.getItemURLGenerator(n, n2).generateURL(multiIntervalCategoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string2, string3, multiIntervalCategoryDataset, n, multiIntervalCategoryDataset.getColumnKey(n2), n2);
            entityCollection.addEntity(categoryItemEntity);
        }
    }
}

