/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;

public class DefaultBoxAndWhiskerXYDataset
extends AbstractSeriesDataset
implements BoxAndWhiskerXYDataset,
RangeInfo {
    private String seriesName;
    private List dates;
    private List items;
    private Number minimumRangeValue;
    private Number maximumRangeValue;
    private Range valueRange;
    private double outlierCoefficient = 1.5;
    private double faroutCoefficient = 2.0;

    public DefaultBoxAndWhiskerXYDataset(String string2) {
        this.seriesName = string2;
        this.dates = new ArrayList();
        this.items = new ArrayList();
        this.minimumRangeValue = null;
        this.maximumRangeValue = null;
        this.valueRange = null;
    }

    public void add(Date date, BoxAndWhiskerItem boxAndWhiskerItem) {
        this.dates.add(date);
        this.items.add(boxAndWhiskerItem);
        if (this.minimumRangeValue == null) {
            this.minimumRangeValue = boxAndWhiskerItem.getMinRegularValue();
        } else if (boxAndWhiskerItem.getMinRegularValue().doubleValue() < this.minimumRangeValue.doubleValue()) {
            this.minimumRangeValue = boxAndWhiskerItem.getMinRegularValue();
        }
        if (this.maximumRangeValue == null) {
            this.maximumRangeValue = boxAndWhiskerItem.getMaxRegularValue();
        } else if (boxAndWhiskerItem.getMaxRegularValue().doubleValue() > this.maximumRangeValue.doubleValue()) {
            this.maximumRangeValue = boxAndWhiskerItem.getMaxRegularValue();
        }
        this.valueRange = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
    }

    public String getSeriesName(int n) {
        return this.seriesName;
    }

    public Number getXValue(int n, int n2) {
        return new Long(((Date)this.dates.get(n2)).getTime());
    }

    public Date getXDate(int n, int n2) {
        return (Date)this.dates.get(n2);
    }

    public Number getYValue(int n, int n2) {
        return new Double(this.getMeanValue(n, n2).doubleValue());
    }

    public Number getMeanValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    public Number getMedianValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    public Number getQ1Value(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    public Number getQ3Value(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    public Number getMinRegularValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    public Number getMaxRegularValue(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    public Number getMinOutlier(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    public Number getMaxOutlier(int n, int n2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    public List getOutliers(int n, int n2) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n2);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    public double getOutlierCoefficient() {
        return this.outlierCoefficient;
    }

    public double getFaroutCoefficient() {
        return this.faroutCoefficient;
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int n) {
        return this.dates.size();
    }

    public void setOutlierCoefficient(double d) {
        this.outlierCoefficient = d;
    }

    public void setFaroutCoefficient(double d) {
        if (!(d > this.getOutlierCoefficient())) {
            throw new IllegalArgumentException("Farout value must be greater than the outlier value, which is currently set at: (" + this.getOutlierCoefficient() + ")");
        }
        this.faroutCoefficient = d;
    }

    public Number getMinimumRangeValue() {
        return this.minimumRangeValue;
    }

    public Number getMaximumRangeValue() {
        return this.maximumRangeValue;
    }

    public Range getValueRange() {
        return this.valueRange;
    }
}

