/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.UtilEvalError;

class ClassNameSpace
extends NameSpace {
    public static final int CLASS = 1;
    public static final int INSTANCE = 2;
    int type;

    public ClassNameSpace(NameSpace nameSpace, String string2, int n) throws EvalError {
        super(nameSpace, string2);
        this.type = n;
    }

    public void setVariable(String string2, Object object, boolean bl) throws UtilEvalError {
        if (this.isClassInstance()) {
            boolean bl2 = false;
            super.setVariable(string2, object, bl, bl2);
        }
        super.setVariable(string2, object, bl);
    }

    protected boolean isVisible(NameSpace.Variable variable) throws UtilEvalError {
        if (this.isClass() && variable != null && !variable.hasModifier("static")) {
            throw new UtilEvalError("Can't reach instance var: " + variable.name + " from static context: " + this);
        }
        return !this.isClassInstance() || variable == null || !variable.hasModifier("static");
    }

    protected boolean isVisible(BshMethod bshMethod) throws UtilEvalError {
        String string2 = null;
        if (bshMethod != null) {
            string2 = bshMethod.getName();
        }
        if (this.isClass() && bshMethod != null && !bshMethod.hasModifier("static") && !string2.equals("_bshClassInit") && !this.nsName.equals(string2)) {
            throw new UtilEvalError("Can't reach instance method: " + string2 + " from static context: " + this);
        }
        return !this.isClassInstance() || bshMethod == null || !bshMethod.hasModifier("static");
    }

    public boolean isClassInstance() {
        return this.type == 2;
    }

    public boolean isClass() {
        return this.type == 1;
    }

    public This constructClassInstance(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        Object object;
        ClassNameSpace classNameSpace = this;
        String string2 = classNameSpace.getName();
        BshMethod bshMethod = null;
        try {
            bshMethod = classNameSpace.getMethod("_bshClassInit", new Class[0]);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Error getting default constructor", simpleNode, callStack);
        }
        if (bshMethod == null) {
            throw new EvalError("Unable to find initializer for class.", simpleNode, callStack);
        }
        Class[] classArray = Reflect.getTypes(objectArray);
        BshMethod bshMethod2 = null;
        try {
            bshMethod2 = classNameSpace.getMethod(string2, classArray);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError("Error getting constructor", simpleNode, callStack);
        }
        if (bshMethod2 == null) {
            if (objectArray.length > 0) {
                throw new EvalError("Constructor not found: " + StringUtil.methodString(string2, classArray), simpleNode, callStack);
            }
            object = classNameSpace.getMethods();
            int n = 0;
            while (n < ((BshMethod[])object).length) {
                if (object[n].getName().equals(string2)) {
                    throw new EvalError("Default (no args) constructor not found: " + StringUtil.methodString(string2, classArray), simpleNode, callStack);
                }
                ++n;
            }
        }
        object = null;
        if (classNameSpace.getParent() instanceof ClassNameSpace && ((ClassNameSpace)classNameSpace.getParent()).isClass()) {
            This this_ = ((ClassNameSpace)classNameSpace.getParent()).constructClassInstance(new Object[0], interpreter, callStack, simpleNode);
            object = this_.getNameSpace();
        }
        ClassNameSpace classNameSpace2 = object != null ? new ClassNameSpace((NameSpace)object, string2, 2) : new ClassNameSpace((NameSpace)classNameSpace, string2, 2);
        callStack.push(classNameSpace2);
        try {
            bshMethod.invoke(new Object[0], interpreter, callStack, simpleNode, true);
        }
        catch (EvalError evalError) {
            evalError.reThrow("Exception in default constructor: " + evalError);
        }
        if (bshMethod2 != null) {
            try {
                bshMethod2.invoke(objectArray, interpreter, callStack, simpleNode, true);
            }
            catch (EvalError evalError) {
                evalError.reThrow("Exception in constructor: " + evalError);
            }
        }
        callStack.pop();
        This this_ = classNameSpace2.getThis(interpreter);
        return this_;
    }

    protected void checkVariableModifiers(String string2, Modifiers modifiers) throws UtilEvalError {
    }

    protected void checkMethodModifiers(BshMethod bshMethod) throws UtilEvalError {
    }

    public String toString() {
        return "Scripted Class " + (this.isClassInstance() ? "Instance " : "") + " : " + super.toString();
    }

    public static boolean isScriptedClass(Object object) {
        return object instanceof This && ((This)object).getNameSpace() instanceof ClassNameSpace && ((ClassNameSpace)((This)object).getNameSpace()).isClass();
    }
}

