/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.engine;

import cern.colt.Timer;
import cern.jet.random.engine.DRand;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.MersenneTwister64;
import cern.jet.random.engine.RandomEngine;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import edu.cornell.lassp.houle.RngPack.Ranecu;
import edu.cornell.lassp.houle.RngPack.Ranlux;
import edu.cornell.lassp.houle.RngPack.Ranmar;
import java.util.Random;

public class Benchmark {
    protected Benchmark() {
        throw new RuntimeException("Non instantiable");
    }

    public static void benchmark(int n) {
        Timer timer = new Timer();
        timer.reset().start();
        int n2 = n;
        while (--n2 >= 0) {
        }
        timer.stop().display();
        float f = timer.elapsedTime();
        System.out.println("empty loop timing done.");
        RandomSeedable randomSeedable = new MersenneTwister();
        System.out.println("\n MersenneTwister:");
        timer.reset().start();
        int n3 = n;
        while (--n3 >= 0) {
            randomSeedable.raw();
        }
        timer.stop().display();
        System.out.println((float)n / (timer.elapsedTime() - f) + " numbers per second.");
        randomSeedable = new MersenneTwister64();
        System.out.println("\n MersenneTwister64:");
        timer.reset().start();
        int n4 = n;
        while (--n4 >= 0) {
            randomSeedable.raw();
        }
        timer.stop().display();
        System.out.println((float)n / (timer.elapsedTime() - f) + " numbers per second.");
        randomSeedable = new DRand();
        System.out.println("\nDRand:");
        timer.reset().start();
        int n5 = n;
        while (--n5 >= 0) {
            randomSeedable.raw();
        }
        timer.stop().display();
        System.out.println((float)n / (timer.elapsedTime() - f) + " numbers per second.");
        Random random2 = new Random();
        System.out.println("\njava.util.Random.nextFloat():");
        timer.reset().start();
        int n6 = n;
        while (--n6 >= 0) {
            random2.nextFloat();
        }
        timer.stop().display();
        System.out.println((float)n / (timer.elapsedTime() - f) + " numbers per second.");
        randomSeedable = new Ranecu();
        System.out.println("\nRanecu:");
        timer.reset().start();
        int n7 = n;
        while (--n7 >= 0) {
            randomSeedable.raw();
        }
        timer.stop().display();
        System.out.println((float)n / (timer.elapsedTime() - f) + " numbers per second.");
        randomSeedable = new Ranmar();
        System.out.println("\nRanmar:");
        timer.reset().start();
        int n8 = n;
        while (--n8 >= 0) {
            randomSeedable.raw();
        }
        timer.stop().display();
        System.out.println((float)n / (timer.elapsedTime() - f) + " numbers per second.");
        randomSeedable = new Ranlux();
        System.out.println("\nRanlux:");
        timer.reset().start();
        int n9 = n;
        while (--n9 >= 0) {
            randomSeedable.raw();
        }
        timer.stop().display();
        System.out.println((float)n / (timer.elapsedTime() - f) + " numbers per second.");
        System.out.println("\nGood bye.\n");
    }

    public static void main(String[] stringArray) {
        long l = Long.parseLong(stringArray[0]);
        long l2 = Long.parseLong(stringArray[1]);
        int n = Integer.parseInt(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        int n3 = 0;
        while (n3 < n2) {
            Benchmark.benchmark(n);
            ++n3;
        }
    }

    public static void test(int n, RandomEngine randomEngine) {
        System.out.println("\n\nint():");
        RandomEngine randomEngine2 = (RandomEngine)randomEngine.clone();
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            System.out.print(" " + randomEngine2.nextInt());
            if (n2 % 8 == 7) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("\n\nGood bye.\n");
    }

    private static void xtestRandomFromTo(long l, long l2, int n) {
        System.out.println("from=" + l + ", to=" + l2);
        Random random2 = new Random();
        MersenneTwister mersenneTwister = new MersenneTwister();
        int n2 = (int)l;
        int n3 = (int)l2;
        Timer timer = new Timer().start();
        int n4 = 0;
        int n5 = n;
        while (--n5 >= 0) {
            System.out.print(" " + ((RandomElement)mersenneTwister).raw());
            if (n4 % 8 == 7) {
                System.out.println();
            }
            ++n4;
        }
        timer.stop().display();
        System.out.println("Good bye.\n");
    }
}

