/*
 * Decompiled with CFR 0.152.
 */
package com.lgc.wsh.inv;

import com.lgc.wsh.inv.Quadratic;
import com.lgc.wsh.inv.Transform;
import com.lgc.wsh.inv.Vect;
import com.lgc.wsh.inv.VectConst;
import com.lgc.wsh.inv.VectUtil;
import com.lgc.wsh.util.Almost;
import java.util.logging.Logger;

public class TransformQuadratic
implements Quadratic {
    private static final Logger LOG;
    private VectConst _data;
    private VectConst _referenceModel;
    private VectConst _perturbModel;
    private Transform _transform;
    private boolean _dampOnlyPerturbation = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TransformQuadratic(VectConst data, VectConst referenceModel, VectConst perturbModel, Transform transform, boolean dampOnlyPerturbation) {
        this._data = data;
        this._referenceModel = referenceModel;
        this._perturbModel = perturbModel;
        this._transform = transform;
        this._dampOnlyPerturbation = dampOnlyPerturbation;
    }

    public int getTransposePrecision() {
        VectConst d = this._data;
        Vect b = this.getB();
        double bb = b.dot(b);
        TransformQuadratic.checkNaN(bb);
        if (!$assertionsDisabled && Almost.FLOAT.zero(bb)) {
            throw new AssertionError((Object)"Cannot test with zero-magnitude b");
        }
        Vect Fb = VectUtil.cloneZero(d);
        Vect bSave = (Vect)b.clone();
        this._transform.forwardLinearized(Fb, b, this._referenceModel);
        if (!$assertionsDisabled && !VectUtil.areSame(b, bSave)) {
            throw new AssertionError((Object)"model was changed by forward model");
        }
        bSave.dispose();
        Vect test = (Vect)d.clone();
        this._transform.forwardLinearized(test, b, this._referenceModel);
        if (!$assertionsDisabled && !VectUtil.areSame(test, Fb)) {
            throw new AssertionError((Object)"forwardLinearized should zero data");
        }
        test.dispose();
        Vect Ad = VectUtil.cloneZero(b);
        Vect dSave = (Vect)d.clone();
        this._transform.addTranspose(d, Ad, this._referenceModel);
        double transposeMagnitude = Ad.dot(Ad);
        TransformQuadratic.checkNaN(transposeMagnitude);
        if (!$assertionsDisabled && !VectUtil.areSame(d, dSave)) {
            throw new AssertionError((Object)"data was changed by transpose");
        }
        dSave.dispose();
        test = (Vect)b.clone();
        double scaleTest = 1.1 * Math.sqrt(transposeMagnitude / bb);
        VectUtil.scale(test, scaleTest);
        this._transform.addTranspose(d, test, this._referenceModel);
        if (!$assertionsDisabled && VectUtil.areSame(Ad, test)) {
            throw new AssertionError((Object)("Transpose should not zero model.  Magnitude: b=" + bb + "trans=" + transposeMagnitude + " test=" + test.dot(test)));
        }
        test.add(1.0, -1.0, Ad);
        VectUtil.scale(test, 1.0 / scaleTest);
        if (!$assertionsDisabled && !VectUtil.areSame(test, b)) {
            throw new AssertionError((Object)"Transpose did not add to model vector");
        }
        test.dispose();
        double dFb = d.dot(Fb);
        double Adb = Ad.dot(b);
        if (!$assertionsDisabled && Almost.FLOAT.zero(dFb)) {
            throw new AssertionError((Object)"zero magnitude test: dFb is zero");
        }
        if (!$assertionsDisabled && Almost.FLOAT.zero(Adb)) {
            throw new AssertionError((Object)"zero magnitude test: Adb is zero");
        }
        TransformQuadratic.checkNaN(dFb);
        TransformQuadratic.checkNaN(Adb);
        int significantDigits = 10;
        boolean matches = false;
        while (!matches && significantDigits > 0) {
            Almost almost = new Almost(significantDigits);
            matches = almost.equal(dFb, Adb);
            if (matches) continue;
            --significantDigits;
        }
        if (significantDigits < 3) {
            LOG.severe("Transpose precision is unacceptable: dFb=" + dFb + " Adb=" + Adb);
        }
        Ad.dispose();
        Fb.dispose();
        b.dispose();
        return significantDigits;
    }

    public void multiplyHessian(Vect x) {
        Object model = null;
        Vect data = (Vect)this._data.clone();
        this._transform.forwardLinearized(data, x, this._referenceModel);
        data.multiplyInverseCovariance();
        x.multiplyInverseCovariance();
        this._transform.addTranspose(data, x, this._referenceModel);
        data.dispose();
    }

    public void inverseHessian(Vect x) {
        this._transform.inverseHessian(x, this._referenceModel);
    }

    public Vect getB() {
        Vect data = VectUtil.cloneZero(this._data);
        this._transform.forwardNonlinear(data, this._referenceModel);
        data.add(1.0, -1.0, this._data);
        this._transform.adjustRobustErrors(data);
        data.multiplyInverseCovariance();
        Vect b = null;
        if (this._dampOnlyPerturbation) {
            b = this._perturbModel != null ? VectUtil.cloneZero(this._perturbModel) : VectUtil.cloneZero(this._referenceModel);
        } else {
            if (this._perturbModel != null) {
                b = (Vect)this._perturbModel.clone();
                b.project(0.0, 1.0, this._referenceModel);
            } else {
                b = (Vect)this._referenceModel.clone();
            }
            b.multiplyInverseCovariance();
        }
        this._transform.addTranspose(data, b, this._referenceModel);
        data.dispose();
        return b;
    }

    public double evalFullObjectiveFunction(VectConst m) {
        Vect data = VectUtil.cloneZero(this._data);
        Vect model = (Vect)m.clone();
        model.constrain();
        this._transform.forwardNonlinear(data, model);
        data.add(1.0, -1.0, this._data);
        this._transform.adjustRobustErrors(data);
        double eNe = data.magnitude();
        TransformQuadratic.checkNaN(eNe);
        data.dispose();
        if (this._dampOnlyPerturbation) {
            model.add(1.0, -1.0, this._referenceModel);
        }
        double mMm = model.magnitude();
        TransformQuadratic.checkNaN(mMm);
        model.dispose();
        return eNe + mMm;
    }

    private static void checkNaN(double value) {
        if (value * 0.0 != 0.0) {
            throw new IllegalStateException("Value is a NaN");
        }
    }

    public void dispose() {
    }

    static {
        $assertionsDisabled = !TransformQuadratic.class.desiredAssertionStatus();
        LOG = Logger.getLogger("com.lgc.wsh.inv");
    }
}

