/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Instance;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassifierTeacher {
    public final Classifier train(ClassifierLearner learner) {
        learner.reset();
        learner.setSchema(this.schema());
        learner.setInstancePool(this.instancePool());
        Iterator<Example> i = this.examplePool();
        while (i.hasNext()) {
            learner.addExample(i.next());
        }
        while (learner.hasNextQuery() && this.hasAnswers()) {
            Instance query = learner.nextQuery();
            Example answeredQuery = this.labelInstance(query);
            if (answeredQuery == null) continue;
            learner.addExample(answeredQuery);
        }
        learner.completeTraining();
        return learner.getClassifier();
    }

    protected abstract ExampleSchema schema();

    protected abstract Iterator<Example> examplePool();

    protected abstract Iterator<Instance> instancePool();

    protected abstract Example labelInstance(Instance var1);

    protected abstract boolean hasAnswers();
}

