/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.OnlineClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.knn.KnnLearner;

public class MistakeCountingOnlineLearner
extends OnlineClassifierLearner {
    private OnlineClassifierLearner innerLearner;
    private int numMistakes;
    private int numExamples;
    private boolean reportMistakes;

    public MistakeCountingOnlineLearner() {
        this(new KnnLearner(), true);
    }

    public MistakeCountingOnlineLearner(OnlineClassifierLearner innerLearner) {
        this(innerLearner, true);
    }

    public MistakeCountingOnlineLearner(OnlineClassifierLearner innerLearner, boolean reportMistakes) {
        this.innerLearner = innerLearner;
        this.reportMistakes = reportMistakes;
        this.numExamples = 0;
        this.numMistakes = 0;
    }

    public ClassifierLearner copy() {
        return new MistakeCountingOnlineLearner((OnlineClassifierLearner)this.innerLearner.copy(), this.reportMistakes);
    }

    public void completeTraining() {
        this.innerLearner.completeTraining();
        if (this.reportMistakes) {
            System.out.println(this.numMistakes + " mistakes in " + this.numExamples + " examples for " + this.innerLearner);
        }
    }

    public void addExample(Example answeredQuery) {
        ClassLabel predicted = this.innerLearner.getClassifier().classification(answeredQuery.asInstance());
        if (!answeredQuery.getLabel().isCorrect(predicted)) {
            ++this.numMistakes;
        }
        ++this.numExamples;
        this.innerLearner.addExample(answeredQuery);
    }

    public Classifier getClassifier() {
        return this.innerLearner.getClassifier();
    }

    public void setSchema(ExampleSchema schema) {
        this.innerLearner.setSchema(schema);
    }

    public ExampleSchema getSchema() {
        return this.innerLearner.getSchema();
    }

    public void reset() {
        this.innerLearner.reset();
        this.numExamples = 0;
        this.numMistakes = 0;
    }

    public int getNumberOfMistakes() {
        return this.numMistakes;
    }

    public int getTotalNumberOfExamples() {
        return this.numExamples;
    }

    public String toString() {
        return "[MistakeCountingOnlineLearner: " + this.numMistakes + "/" + this.numExamples + " mistakes for " + this.innerLearner + "]";
    }
}

