/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.BatchClassifierLearner;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.ClassifierLearnerFactory;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.OneVsAllClassifier;
import edu.cmu.minorthird.classify.OneVsAllLearner;
import java.util.ArrayList;
import java.util.Iterator;

public class MostFrequentFirstLearner
extends OneVsAllLearner {
    public String[] sortedClassNames;

    public MostFrequentFirstLearner() {
    }

    public MostFrequentFirstLearner(ClassifierLearnerFactory learnerFactory) {
        super(learnerFactory);
    }

    public MostFrequentFirstLearner(String l) {
        super(l);
    }

    public MostFrequentFirstLearner(BatchClassifierLearner learner) {
        this.learner = learner;
        this.learnerName = learner.toString();
        this.learnerFactory = new ClassifierLearnerFactory(this.learnerName);
    }

    private void sortLearners() {
        ArrayList<BatchClassifierLearner> unsortedLearners = new ArrayList<BatchClassifierLearner>();
        String[] classNames = this.schema.validClassNames();
        ArrayList<String> unsortedClassNames = new ArrayList<String>();
        this.sortedClassNames = new String[this.schema.getNumberOfClasses()];
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            unsortedLearners.add((BatchClassifierLearner)this.innerLearner.get(i));
            unsortedClassNames.add(classNames[i]);
        }
        this.innerLearner.clear();
        int position = 0;
        while (!unsortedLearners.isEmpty()) {
            String className;
            int maxPosEx = 0;
            int learnerIndex = -1;
            for (int j = 0; j < unsortedLearners.size(); ++j) {
                try {
                    BatchClassifierLearner learner = (BatchClassifierLearner)unsortedLearners.get(j);
                    Dataset d = learner.dataset;
                    int numPosEx = 0;
                    Iterator<Example> it = d.iterator();
                    while (it.hasNext()) {
                        Example example = it.next();
                        if (!example.getLabel().isPositive()) continue;
                        ++numPosEx;
                    }
                    if (numPosEx <= maxPosEx) continue;
                    maxPosEx = numPosEx;
                    learnerIndex = j;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ClassifierLearner learner = (ClassifierLearner)unsortedLearners.remove(learnerIndex);
            this.innerLearner.add(learner);
            this.sortedClassNames[position] = className = (String)unsortedClassNames.remove(learnerIndex);
            ++position;
        }
    }

    public void completeTraining() {
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            ((ClassifierLearner)this.innerLearner.get(i)).completeTraining();
        }
        this.sortLearners();
    }

    public Classifier getClassifier() {
        Classifier[] classifiers = new Classifier[this.innerLearner.size()];
        for (int i = 0; i < this.innerLearner.size(); ++i) {
            classifiers[i] = ((ClassifierLearner)this.innerLearner.get(i)).getClassifier();
        }
        return new OneVsAllClassifier(this.sortedClassNames, classifiers);
    }
}

