/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetClassifierTeacher;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.StackedClassifierTeacher;
import edu.cmu.minorthird.classify.Util;
import edu.cmu.minorthird.classify.experiments.Expt;
import edu.cmu.minorthird.classify.experiments.Tester;
import edu.cmu.minorthird.classify.relational.RealRelationalDataset;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackedDatasetClassifierTeacher
extends StackedClassifierTeacher {
    private Dataset dataset;
    private boolean activeLearning = false;

    public StackedDatasetClassifierTeacher(Dataset dataset) {
        this(dataset, false);
    }

    public StackedDatasetClassifierTeacher(Dataset dataset, boolean activeLearning) {
        this.dataset = dataset;
        this.activeLearning = activeLearning;
    }

    @Override
    public ExampleSchema schema() {
        return this.dataset.getSchema();
    }

    @Override
    public Map<String, Map<String, Set<String>>> getLinksMap() {
        return RealRelationalDataset.getLinksMap();
    }

    @Override
    public Map<String, Set<String>> getAggregators() {
        return RealRelationalDataset.getAggregators();
    }

    @Override
    public Iterator<Example> examplePool() {
        if (this.activeLearning) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.dataset.iterator();
    }

    @Override
    public Iterator<Instance> instancePool() {
        if (this.activeLearning) {
            return Util.toInstanceIterator(this.dataset.iterator());
        }
        if (this.dataset instanceof BasicDataset) {
            return ((BasicDataset)this.dataset).iteratorOverUnlabeled();
        }
        return Collections.EMPTY_SET.iterator();
    }

    @Override
    public Example labelInstance(Instance query) {
        if (query instanceof Example) {
            return (Example)query;
        }
        return null;
    }

    @Override
    public boolean hasAnswers() {
        return this.activeLearning;
    }

    public static void main(String[] argv) {
        try {
            Dataset dataset = Expt.toDataset(argv[0]);
            ClassifierLearner learner = Expt.toLearner(argv[1]);
            Classifier c = new DatasetClassifierTeacher(dataset).train(learner);
            if (c instanceof Visible) {
                new ViewerFrame("from " + argv[0] + " and " + argv[1], ((Visible)((Object)c)).toGUI());
            } else {
                System.out.println("Learnt classifier: " + c);
            }
            System.out.println("Training error:   " + Tester.errorRate(c, dataset));
            if (c instanceof BinaryClassifier) {
                System.out.println("Average log loss: " + Tester.logLoss((BinaryClassifier)c, dataset));
            }
            if (argv.length >= 3 && c instanceof Serializable) {
                IOUtil.saveSerialized((Serializable)((Object)c), new File(argv[2]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("usage: dataset learner [classifierFile]");
        }
    }
}

