/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.active;

import edu.cmu.minorthird.classify.BatchClassifierLearner;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.RandomAccessDataset;
import edu.cmu.minorthird.classify.algorithms.active.CommitteeLearner;
import edu.cmu.minorthird.classify.algorithms.trees.DecisionTreeLearner;
import gnu.trove.TObjectDoubleHashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryByCommittee
implements ClassifierLearner {
    private static Logger log = Logger.getLogger(QueryByCommittee.class);
    private ClassifierLearner innerLearner;
    private int minLabelsBeforeQuerying = 5;
    private CommitteeLearner committeeLearner;
    private ExampleSchema schema;
    private TreeMap<Double, Instance> unlabeled;
    private RandomAccessDataset labeled;

    public QueryByCommittee() {
        this(new DecisionTreeLearner(), 5);
    }

    public QueryByCommittee(BatchClassifierLearner learner, int committeeSize) {
        this.committeeLearner = new CommitteeLearner(learner, committeeSize);
        this.innerLearner = learner;
        this.reset();
    }

    @Override
    public ClassifierLearner copy() {
        ClassifierLearner learner = null;
        try {
            learner = (ClassifierLearner)this.clone();
            learner.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return learner;
    }

    @Override
    public final void reset() {
        this.unlabeled = new TreeMap();
        this.labeled = new RandomAccessDataset();
        this.innerLearner.reset();
    }

    @Override
    public final void setSchema(ExampleSchema schema) {
        this.schema = schema;
    }

    @Override
    public final ExampleSchema getSchema() {
        return this.schema;
    }

    @Override
    public final void setInstancePool(Iterator<Instance> i) {
        this.unlabeled.clear();
        Random r = new Random(0L);
        while (i.hasNext()) {
            this.unlabeled.put(r.nextDouble(), i.next());
        }
        log.info(this.unlabeled.size() + " unlabeled examples available");
    }

    @Override
    public final boolean hasNextQuery() {
        return this.unlabeled.size() > 0;
    }

    @Override
    public final Instance nextQuery() {
        Object key = null;
        if (this.labeled.size() < this.minLabelsBeforeQuerying) {
            log.info("will pick next unlabeled example");
            key = this.unlabeled.firstKey();
        } else {
            log.info("will use committee to pick an unlabeled example");
            Classifier[] committee = this.committeeLearner.batchTrainCommittee(this.labeled);
            key = this.keyOfBestUnlabeledInstance(committee);
        }
        Instance query = this.unlabeled.get(key);
        this.unlabeled.remove(key);
        return query;
    }

    private Object keyOfBestUnlabeledInstance(Classifier[] committee) {
        double worstAgreement = 2.0;
        Double queryKey = null;
        for (Double key : this.unlabeled.keySet()) {
            Instance instance = this.unlabeled.get(key);
            TObjectDoubleHashMap counts = new TObjectDoubleHashMap();
            double biggestCount = 0.0;
            for (int j = 0; j < committee.length; ++j) {
                String best = committee[j].classification(instance).bestClassName();
                double c = counts.get(best) + 1.0;
                counts.put(best, c);
                if (!(c > biggestCount)) continue;
                biggestCount = c;
            }
            double agreement = biggestCount / (double)committee.length;
            log.info("instance: " + instance + " committee: " + counts + " agreement: " + agreement);
            if (!(agreement < worstAgreement)) continue;
            worstAgreement = agreement;
            queryKey = key;
            log.debug(" ==> best");
        }
        log.info("queryInstance is: " + this.unlabeled.get(queryKey));
        return queryKey;
    }

    @Override
    public void addExample(Example example) {
        log.info("adding example: " + example);
        this.labeled.add(example);
        this.innerLearner.addExample(example);
    }

    @Override
    public final void completeTraining() {
        this.innerLearner.completeTraining();
    }

    @Override
    public Classifier getClassifier() {
        return this.innerLearner.getClassifier();
    }
}

