/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class NaiveBayes
extends OnlineBinaryClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20080130L;
    private static Logger log = Logger.getLogger(NaiveBayes.class);
    private Hyperplane numGivenPos;
    private Hyperplane numGivenNeg;
    private Set<Feature> featureSet;
    private double numPos;
    private double numNeg;

    public NaiveBayes() {
        this.reset();
    }

    public void reset() {
        log.info("resetting NaiveBayes");
        this.numGivenPos = new Hyperplane();
        this.numGivenNeg = new Hyperplane();
        this.featureSet = new HashSet<Feature>();
        this.numPos = 0.0;
        this.numNeg = 0.0;
    }

    public void addExample(Example example) {
        boolean isPos = example.getLabel().isPositive();
        if (isPos) {
            this.numPos += example.getWeight();
        } else {
            this.numNeg += example.getWeight();
        }
        Iterator<Feature> i = example.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            if (isPos) {
                this.numGivenPos.increment(f, 1.0);
            } else {
                this.numGivenNeg.increment(f, 1.0);
            }
            this.featureSet.add(f);
        }
    }

    public Classifier getClassifier() {
        Hyperplane c = new Hyperplane();
        for (Feature f : this.featureSet) {
            double featurePrior = this.getFeaturePrior();
            double m = this.getFeaturePriorPseudoCount();
            double pweight = this.estimatedLogProb(this.numGivenPos.featureScore(f), this.numPos, featurePrior, m);
            double nweight = this.estimatedLogProb(this.numGivenNeg.featureScore(f), this.numNeg, featurePrior, m);
            c.increment(f, pweight - nweight);
        }
        c.incrementBias(this.estimatedLogProb(this.numPos, this.numPos + this.numNeg, 0.5, 1.0));
        c.incrementBias(-this.estimatedLogProb(this.numNeg, this.numPos + this.numNeg, 0.5, 1.0));
        return c;
    }

    private double estimatedLogProb(double k, double n, double prior, double pseudoCounts) {
        return Math.log((k + prior * pseudoCounts) / (n + pseudoCounts));
    }

    private double getFeaturePrior() {
        return 1.0 / (double)this.featureSet.size();
    }

    private double getFeaturePriorPseudoCount() {
        return 1.0;
    }

    public String toString() {
        return "[NaiveBayes]";
    }
}

