/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.linear;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Classifier;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.MutableInstance;
import edu.cmu.minorthird.classify.OnlineBinaryClassifierLearner;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TransformedViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import java.util.Iterator;

public class Winnow
extends OnlineBinaryClassifierLearner
implements Serializable {
    static final long serialVersionUID = 20080130L;
    private Hyperplane s_t;
    private Hyperplane v_t;
    private double theta = 1.0;
    private double alpha;
    private double beta;
    private int excount;
    private double margin = 0.0;
    private boolean voted = false;
    private double W_MAX = Math.pow(2.0, 200.0);
    private double W_MIN = 1.0 / Math.pow(2.0, 200.0);
    private int votedCount = 0;

    public Winnow() {
        this(1.5, 0.5, false);
    }

    public Winnow(boolean voted) {
        this(1.5, 0.5, voted);
    }

    public Winnow(double a, double b, boolean voted) {
        if (a < 1.0 || b < 0.0 || b > 1.0) {
            System.out.println("Error in Winnow initial parameters");
            System.out.println("Error: (theta<0)||(alpha < 1)||(beta<0)||(beta>1)");
            System.exit(0);
        }
        this.alpha = a;
        this.beta = b;
        this.voted = voted;
        this.reset();
    }

    public void reset() {
        this.s_t = new Hyperplane();
        if (this.voted) {
            this.v_t = new Hyperplane();
            this.votedCount = 0;
        }
        this.excount = 0;
    }

    public void addExample(Example example1) {
        double y_t_hat;
        ++this.excount;
        Example example = Winnow.normalizeWeights(example1, true);
        Iterator<Feature> j = example.asInstance().featureIterator();
        while (j.hasNext()) {
            Feature f = j.next();
            if (this.s_t.hasFeature(f)) continue;
            this.s_t.increment(f, 1.0);
        }
        double y_t = example.getLabel().numericLabel();
        if (y_t * (y_t_hat = this.s_t.score(example.asInstance()) - this.theta) <= this.margin) {
            if (this.voted) {
                if (this.votedCount == 0) {
                    this.updateVotedHyperplane(1.0);
                } else {
                    this.updateVotedHyperplane(this.votedCount);
                }
                this.votedCount = 1;
            }
            if (example.getLabel().isPositive()) {
                Iterator<Feature> j2 = example.featureIterator();
                while (j2.hasNext()) {
                    Feature f = j2.next();
                    double w = this.s_t.featureScore(f);
                    if (!(w < this.W_MAX)) continue;
                    this.s_t.multiply(f, this.alpha);
                }
            } else {
                Iterator<Feature> j3 = example.featureIterator();
                while (j3.hasNext()) {
                    Feature f = j3.next();
                    double w = this.s_t.featureScore(f);
                    if (!(w > this.W_MIN)) continue;
                    this.s_t.multiply(f, this.beta);
                }
            }
        } else {
            ++this.votedCount;
        }
    }

    public void updateVotedHyperplane(double count) {
        this.v_t.increment(this.s_t, count);
        this.votedCount = 0;
    }

    public Classifier getClassifier() {
        if (this.voted) {
            this.updateVotedHyperplane(this.votedCount);
            Hyperplane z = new Hyperplane();
            z.increment(this.v_t, 1.0 / (double)this.excount);
            return new MyClassifier(z, this.theta);
        }
        return new MyClassifier(this.s_t, this.theta);
    }

    public String toString() {
        return "Winnow, voted=" + this.voted;
    }

    public static Example normalizeWeights(Example ex, boolean dummy) {
        double soma = 0.0;
        Iterator<Feature> i = ex.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            soma += Math.abs(ex.getWeight(f));
        }
        if (dummy) {
            soma += 1.0;
        }
        MutableInstance ins = new MutableInstance();
        Iterator<Feature> i2 = ex.featureIterator();
        while (i2.hasNext()) {
            Feature f = i2.next();
            double weight = ex.getWeight(f) / soma;
            ins.addNumeric(f, weight);
        }
        if (dummy) {
            ins.addNumeric(new Feature("DUMMY"), 1.0 / soma);
        }
        return new Example(ins, ex.getLabel());
    }

    public static class MyClassifier
    implements Classifier,
    Serializable,
    Visible {
        private static final long serialVersionUID = 20080130L;
        private Hyperplane cl;
        private double theta;

        public MyClassifier(Hyperplane cl, double mytheta) {
            this.cl = cl;
            this.theta = mytheta;
        }

        public ClassLabel classification(Instance ins) {
            Example ex = new Example(ins, new ClassLabel("POS"));
            Example example1 = this.filterFeat(ex);
            Example example2 = Winnow.normalizeWeights(example1, true);
            Instance instance = example2.asInstance();
            double dec = this.cl.score(instance) - this.theta;
            return dec >= 0.0 ? ClassLabel.positiveLabel(dec) : ClassLabel.negativeLabel(dec);
        }

        public Example filterFeat(Example ex) {
            MutableInstance ins = new MutableInstance();
            Iterator<Feature> i = ex.asInstance().featureIterator();
            while (i.hasNext()) {
                Feature f = i.next();
                if (!this.cl.hasFeature(f)) continue;
                ins.addNumeric(f, ex.getWeight(f));
            }
            return new Example(ins, ex.getLabel());
        }

        public String toString() {
            return this.cl.toString();
        }

        public String explain(Instance instance) {
            return "Winnow: Not implemented yet";
        }

        public Explanation getExplanation(Instance instance) {
            Explanation.Node top = new Explanation.Node("Winnow Explanation");
            Explanation ex = new Explanation(top);
            return ex;
        }

        public Viewer toGUI() {
            TransformedViewer v = new TransformedViewer(new SmartVanillaViewer()){
                static final long serialVersionUID = 20080130L;

                public Object transform(Object o) {
                    MyClassifier mycl = (MyClassifier)o;
                    return mycl.cl;
                }
            };
            v.setContent(this);
            return v;
        }
    }
}

