/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.svm;

import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.FeatureFactory;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.algorithms.linear.Hyperplane;
import edu.cmu.minorthird.classify.algorithms.svm.SVMUtils;
import edu.cmu.minorthird.util.MathUtil;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.ControlledViewer;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.Visible;
import edu.cmu.minorthird.util.gui.ZoomedViewer;
import java.awt.Component;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import libsvm.m3gateway;
import libsvm.svm_model;
import libsvm.svm_node;

public class VisibleSVM
implements Visible,
Serializable {
    static final long serialVersionUID = 20071130L;
    private String[] m_classStrLabels;
    private Example[] m_examples;
    private String[][] m_exampleWeightLabels;
    private m3gateway m_gate;
    private Hyperplane[] m_hyperplanes;
    private int m_posIndicator;
    private String[] m_hpLabels;

    public VisibleSVM(svm_model model, FeatureFactory factory) {
        this(model, factory, null);
    }

    public VisibleSVM(svm_model model, FeatureFactory factory, ExampleSchema schema) {
        this.initialize(model, schema);
        this.setExamples(model, factory);
        if (this.m_hyperplanes.length > 1) {
            this.setHyperplanes();
        } else {
            this.setHyperplane();
        }
    }

    public Example[] getExamples() {
        return this.m_examples;
    }

    public String[][] getExampleWeightLabels() {
        return this.m_exampleWeightLabels;
    }

    public Hyperplane getHyperplane(int index) {
        if (index < 0 || index >= this.m_hyperplanes.length) {
            throw new IllegalArgumentException("out of range: " + index);
        }
        return this.m_hyperplanes[index];
    }

    public String getHyperplaneLabel(int index) {
        if (index < 0 || index >= this.m_hpLabels.length) {
            throw new IllegalArgumentException("out of range: " + index);
        }
        return this.m_hpLabels[index];
    }

    private void addInfoToHyperplane(int exampleIndex, int hyperplaneIndex) {
        Iterator<Feature> flidx = this.m_examples[exampleIndex].featureIterator();
        while (flidx.hasNext()) {
            Feature ftemp = flidx.next();
            double featureWeightTemp = this.m_examples[exampleIndex].getWeight(ftemp);
            this.m_hyperplanes[hyperplaneIndex].increment(ftemp, featureWeightTemp *= this.m_examples[exampleIndex].getWeight());
        }
    }

    private void initialize(svm_model model, ExampleSchema schema) {
        this.m_gate = new m3gateway(model);
        int[] labelTypes = this.m_gate.getLabelForEachClass();
        if (schema != null) {
            this.setClassStrLabels(schema);
        } else {
            this.setClassStrLabels();
        }
        this.m_posIndicator = labelTypes.length == 2 && this.m_classStrLabels[0].equals("POS") || labelTypes.length > 2 ? 1 : -1;
        double[] rhos = this.m_gate.getConstantsInDecisionFunctions();
        this.m_hyperplanes = new Hyperplane[rhos.length];
        this.m_hpLabels = new String[this.m_hyperplanes.length];
        for (int index = 0; index < this.m_hyperplanes.length; ++index) {
            this.m_hyperplanes[index] = new Hyperplane();
            this.m_hyperplanes[index].setBias(-1.0 * rhos[index] * (double)this.m_posIndicator);
        }
    }

    private void initExampleWeightLabels() {
        if (this.m_hyperplanes.length == 1) {
            for (int index = 0; index < this.m_exampleWeightLabels.length; ++index) {
                DecimalFormat df = new DecimalFormat("0.0000");
                this.m_exampleWeightLabels[index][0] = df.format(this.m_examples[index].getWeight());
            }
        } else {
            for (int index = 0; index < this.m_exampleWeightLabels.length; ++index) {
                for (int idx = 0; idx < this.m_exampleWeightLabels[0].length; ++idx) {
                    this.m_exampleWeightLabels[index][idx] = "null";
                }
            }
        }
    }

    private void setExamples(svm_model model, FeatureFactory factory) {
        svm_node[][] supportVectorsTemp = this.m_gate.getSVMnodes();
        int[] numSVs = this.m_gate.getNumSVsForEachClass();
        double[][] coef = this.m_gate.getCoefficientsForSVsInDecisionFunctions();
        int labelIndex = 0;
        int upperBoundIndex = numSVs[0];
        int numOfSupportVectors = supportVectorsTemp.length;
        this.m_examples = new Example[numOfSupportVectors];
        this.m_exampleWeightLabels = new String[this.m_examples.length][this.m_hyperplanes.length];
        for (int index = 0; index < numOfSupportVectors; ++index) {
            ClassLabel clTemp = new ClassLabel(this.m_classStrLabels[labelIndex]);
            double weightTemp = (double)this.m_posIndicator * coef[0][index];
            Instance iTemp = SVMUtils.nodeArrayToInstance(supportVectorsTemp[index], factory);
            this.m_examples[index] = new Example(iTemp, clTemp, weightTemp);
            if (index != upperBoundIndex - 1 || index == numOfSupportVectors - 1) continue;
            upperBoundIndex += numSVs[++labelIndex];
        }
        this.initExampleWeightLabels();
    }

    private void setHyperplane() {
        this.m_hpLabels[0] = "";
        int numOfSupportVectors = 0;
        int[] numSVs = this.m_gate.getNumSVsForEachClass();
        for (int idx = 0; idx < numSVs.length; ++idx) {
            numOfSupportVectors += numSVs[idx];
        }
        for (int index = 0; index < numOfSupportVectors; ++index) {
            Iterator<Feature> flidx = this.m_examples[index].featureIterator();
            while (flidx.hasNext()) {
                Feature ftemp = flidx.next();
                double featureWeightTemp = this.m_examples[index].getWeight(ftemp);
                this.m_hyperplanes[0].increment(ftemp, featureWeightTemp *= this.m_examples[index].getWeight());
            }
        }
    }

    private void setHyperplanes() {
        int[] labelTypes = this.m_gate.getLabelForEachClass();
        double[][] coef = this.m_gate.getCoefficientsForSVsInDecisionFunctions();
        int[] numSVs = this.m_gate.getNumSVsForEachClass();
        int[] startIdx = new int[labelTypes.length];
        startIdx[0] = 0;
        for (int index = 1; index < startIdx.length; ++index) {
            startIdx[index] = startIdx[index - 1] + numSVs[index - 1];
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        int hpIndex = 0;
        for (int iIdx = 0; iIdx < labelTypes.length; ++iIdx) {
            for (int jIdx = iIdx + 1; jIdx < labelTypes.length; ++jIdx) {
                int exampleIdx;
                this.m_hpLabels[hpIndex] = this.m_classStrLabels[iIdx] + " vs. " + this.m_classStrLabels[jIdx];
                int label0svsCount = numSVs[iIdx];
                int label1svsCount = numSVs[jIdx];
                int label0startedSVindex = startIdx[iIdx];
                int label1startedSVindex = startIdx[jIdx];
                for (exampleIdx = label0startedSVindex; exampleIdx < label0startedSVindex + label0svsCount; ++exampleIdx) {
                    this.m_examples[exampleIdx].setWeight(coef[jIdx - 1][exampleIdx]);
                    this.m_exampleWeightLabels[exampleIdx][hpIndex] = df.format(coef[jIdx - 1][exampleIdx]);
                    this.addInfoToHyperplane(exampleIdx, hpIndex);
                }
                for (exampleIdx = label1startedSVindex; exampleIdx < label1startedSVindex + label1svsCount; ++exampleIdx) {
                    this.m_examples[exampleIdx].setWeight(coef[iIdx][exampleIdx]);
                    this.m_exampleWeightLabels[exampleIdx][hpIndex] = df.format(coef[iIdx][exampleIdx]);
                    this.addInfoToHyperplane(exampleIdx, hpIndex);
                }
                ++hpIndex;
            }
        }
    }

    private void setClassStrLabels() {
        int[] numericLabels = this.m_gate.getLabelForEachClass();
        this.m_classStrLabels = new String[numericLabels.length];
        for (int index = 0; index < this.m_classStrLabels.length; ++index) {
            this.m_classStrLabels[index] = numericLabels[index] == 1 ? "POS" : "NEG";
        }
    }

    private void setClassStrLabels(ExampleSchema schema) {
        int[] numericLabels = this.m_gate.getLabelForEachClass();
        this.m_classStrLabels = new String[numericLabels.length];
        for (int index = 0; index < this.m_classStrLabels.length; ++index) {
            this.m_classStrLabels[index] = schema.getClassName(numericLabels[index]);
        }
    }

    public Viewer toGUI() {
        ParallelViewer pv = new ParallelViewer();
        ControlledViewer svsGui = new ControlledViewer(new SVsViewer(), new SVsControls(this.m_hpLabels.length, this.m_hpLabels));
        svsGui.setContent(this);
        GUI.ExampleViewer svDetailGui = new GUI.ExampleViewer();
        pv.addSubView("Support Vectors", new ZoomedViewer(svsGui, svDetailGui));
        for (int index = 0; index < this.m_hyperplanes.length; ++index) {
            SVMHyperPlaneViewer hyperplaneViewer0 = new SVMHyperPlaneViewer();
            hyperplaneViewer0.setHypid(index);
            hyperplaneViewer0.receiveContent(this);
            pv.addSubView(this.m_hpLabels[index] + " Hyperplane", hyperplaneViewer0);
        }
        return pv;
    }

    private static class SVMHyperPlaneViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20071130L;
        private int m_hyperplaneId;

        private SVMHyperPlaneViewer() {
        }

        public boolean canReceive(Object o) {
            return o instanceof VisibleSVM;
        }

        public JComponent componentFor(Object o) {
            VisibleSVM vsSVM = (VisibleSVM)o;
            return vsSVM.getHyperplane(this.m_hyperplaneId).toGUI();
        }

        public void setHypid(int id) {
            this.m_hyperplaneId = id;
        }
    }

    private static class SVsViewer
    extends ComponentViewer
    implements Controllable {
        static final long serialVersionUID = 20071130L;
        private SVsControls controls = null;
        private VisibleSVM vsSVM = null;

        private SVsViewer() {
        }

        public void applyControls(ViewerControls controls) {
            this.controls = (SVsControls)controls;
            this.setContent(this.vsSVM, true);
            this.revalidate();
        }

        public boolean canReceive(Object o) {
            return o instanceof VisibleSVM;
        }

        public JComponent componentFor(Object o) {
            this.vsSVM = (VisibleSVM)o;
            Example[] exampleTemp = this.vsSVM.getExamples();
            String[][] exampleWeightsTemp = this.vsSVM.getExampleWeightLabels();
            int numCols = 1 + exampleWeightsTemp[0].length;
            Object[][] tableData = new Object[exampleTemp.length][numCols];
            for (int index = 0; index < exampleTemp.length; ++index) {
                for (int wIdx = 0; wIdx < numCols - 1; ++wIdx) {
                    tableData[index][wIdx] = exampleWeightsTemp[index][wIdx];
                }
                tableData[index][numCols - 1] = exampleTemp[index];
            }
            Object[] columnNames = new String[numCols];
            if (numCols == 2) {
                columnNames[0] = "Weight";
            } else {
                for (int index = 0; index < numCols - 1; ++index) {
                    columnNames[index] = "Weight (" + this.vsSVM.getHyperplaneLabel(index) + ")";
                }
            }
            columnNames[numCols - 1] = "Example";
            if (this.controls != null) {
                this.sortTableData(tableData, this.controls.getSelectedButtonIndex());
            } else {
                this.sortTableData(tableData, 0);
            }
            JTable table = new JTable(tableData, columnNames);
            table.setDefaultRenderer(Example.class, new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return GUI.conciseExampleRendererComponent((Example)value, 60, isSelected);
                }
            });
            this.monitorSelections(table, numCols - 1);
            JScrollPane scrollpane = new JScrollPane(table);
            scrollpane.setHorizontalScrollBarPolicy(30);
            return scrollpane;
        }

        private void sortTableData(Object[][] tableData, int index) {
            final int fidx = index;
            Arrays.sort(tableData, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] ra, Object[] rb) {
                    if (rb[fidx].toString() == "null") {
                        if (ra[fidx].toString() == "null") {
                            return 0;
                        }
                        return -1;
                    }
                    if (ra[fidx].toString() == "null") {
                        return 1;
                    }
                    Double da = Double.valueOf(ra[fidx].toString());
                    Double db = Double.valueOf(rb[fidx].toString());
                    return MathUtil.sign(db - da);
                }
            });
        }
    }

    private static class SVsControls
    extends ViewerControls {
        static final long serialVersionUID = 20071130L;
        private int m_numButtons;
        private String[] m_buttonLabels;
        private JRadioButton[] weightTypeButton;

        public SVsControls(int numButtons, String[] buttonLabels) {
            this.m_numButtons = numButtons;
            this.m_buttonLabels = new String[buttonLabels.length];
            for (int index = 0; index < this.m_numButtons; ++index) {
                this.m_buttonLabels[index] = buttonLabels[index];
            }
            this.weightTypeButton = new JRadioButton[this.m_numButtons];
            ButtonGroup group = new ButtonGroup();
            this.add(new JLabel("   Sort by"));
            this.weightTypeButton[0] = this.m_buttonLabels[0].equals("") ? this.addButton("weight", group, true) : this.addButton("weight(" + this.m_buttonLabels[0] + ")", group, true);
            for (int index = 1; index < this.m_numButtons; ++index) {
                this.weightTypeButton[index] = this.addButton("weight(" + this.m_buttonLabels[index] + ")", group, false);
            }
        }

        public void initialize() {
        }

        public int getSelectedButtonIndex() {
            for (int index = 1; index < this.m_numButtons; ++index) {
                if (!this.weightTypeButton[index].isSelected()) continue;
                return index;
            }
            return 0;
        }

        private JRadioButton addButton(String s, ButtonGroup group, boolean selected) {
            JRadioButton button = new JRadioButton(s, selected);
            group.add(button);
            this.add(button);
            button.addActionListener(this);
            return button;
        }
    }
}

