/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.algorithms.trees;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Explanation;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

abstract class DecisionTree
extends BinaryClassifier
implements Serializable,
Visible {
    static final long serialVersionUID = 20080609L;

    DecisionTree() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        this.toString(buf, 0);
        return buf.toString();
    }

    public void toString(StringBuffer buf, int tab) {
        for (int i = 0; i < tab; ++i) {
            buf.append("|  ");
        }
        if (this instanceof InternalNode) {
            InternalNode in = (InternalNode)this;
            buf.append(in.test + ">=" + in.threshold + ":\n");
        } else {
            Leaf leaf = (Leaf)this;
            buf.append(leaf.getScore() + "\n");
        }
    }

    public static class TreeViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080609L;

        public JComponent componentFor(Object o) {
            DecisionTree dtree = (DecisionTree)o;
            DefaultMutableTreeNode top = this.createNodes(dtree);
            final JTree jtree = new JTree(top);
            jtree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)jtree.getLastSelectedPathComponent();
                    Object nodeInfo = node.getUserObject();
                    if (nodeInfo instanceof InternalNode) {
                        TreeViewer.this.sendSignal(3, ((InternalNode)nodeInfo).test);
                    }
                }
            });
            return new JScrollPane(jtree);
        }

        private DefaultMutableTreeNode createNodes(DecisionTree dtree) {
            if (dtree instanceof Leaf) {
                return new DefaultMutableTreeNode(dtree);
            }
            InternalNode internal = (InternalNode)dtree;
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(internal);
            n.add(this.createNodes(internal.ifTrue));
            n.add(this.createNodes(internal.ifFalse));
            return n;
        }
    }

    public static class Leaf
    extends DecisionTree
    implements Visible {
        static final long serialVersionUID = 20080609L;
        private double myScore;

        public Leaf(double myScore) {
            this.myScore = myScore;
        }

        public String explain(Instance instance) {
            return "leaf: " + this.myScore;
        }

        public Explanation getExplanation(Instance instance) {
            Explanation.Node top = new Explanation.Node("leaf: " + this.myScore);
            Explanation ex = new Explanation(top);
            return ex;
        }

        public double score(Instance instance) {
            return this.myScore;
        }

        public double getScore() {
            return this.myScore;
        }

        public Viewer toGUI() {
            TreeViewer v = new TreeViewer();
            ((Viewer)v).receiveContent(this);
            return v;
        }
    }

    public static class InternalNode
    extends DecisionTree
    implements Visible {
        static final long serialVersionUID = 20080609L;
        private Feature test;
        private double threshold;
        private DecisionTree ifTrue;
        private DecisionTree ifFalse;

        public InternalNode(Feature test, DecisionTree ifTrue, DecisionTree ifFalse) {
            this(test, 0.5, ifTrue, ifFalse);
        }

        public InternalNode(Feature test, double threshold, DecisionTree ifTrue, DecisionTree ifFalse) {
            this.test = test;
            this.threshold = threshold;
            this.ifTrue = ifTrue;
            this.ifFalse = ifFalse;
        }

        public String explain(Instance instance) {
            if (instance.getWeight(this.test) >= this.threshold) {
                return this.test + "=" + instance.getWeight(this.test) + ">=" + this.threshold + "\n" + this.ifTrue.explain(instance);
            }
            return this.test + "=" + instance.getWeight(this.test) + "<" + this.threshold + "\n" + this.ifFalse.explain(instance);
        }

        public Explanation getExplanation(Instance instance) {
            Explanation.Node node;
            Explanation.Node top = new Explanation.Node("DecisionTree Explanation");
            if (instance.getWeight(this.test) >= this.threshold) {
                node = new Explanation.Node(this.test + "=" + instance.getWeight(this.test) + ">=" + this.threshold);
                Explanation.Node childEx = this.ifTrue.getExplanation(instance).getTopNode();
                node.add(childEx);
                top.add(node);
            } else {
                node = new Explanation.Node(this.test + "=" + instance.getWeight(this.test) + "<" + this.threshold);
                Explanation.Node childEx = this.ifFalse.getExplanation(instance).getTopNode();
                node.add(childEx);
                top.add(node);
            }
            Explanation ex = new Explanation(top);
            return ex;
        }

        public double score(Instance instance) {
            if (instance.getWeight(this.test) >= this.threshold) {
                return this.ifTrue.score(instance);
            }
            return this.ifFalse.score(instance);
        }

        public DecisionTree getTrueBranch() {
            return this.ifTrue;
        }

        public DecisionTree getFalseBranch() {
            return this.ifFalse;
        }

        public Viewer toGUI() {
            TreeViewer v = new TreeViewer();
            v.setContent(this);
            return v;
        }
    }
}

