/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.experiments;

import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.SubpopSorter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossValSplitter<T>
implements Splitter<T> {
    private Random random;
    private int folds;
    private List<List<T>> subpops;

    public CrossValSplitter(Random random2, int folds) {
        this.random = random2;
        this.folds = folds;
    }

    public CrossValSplitter(int folds) {
        this(new Random(), folds);
    }

    public CrossValSplitter() {
        this(new Random(), 5);
    }

    public int getNumberOfFolds() {
        return this.folds;
    }

    public void setNumberOfFolds(int k) {
        this.folds = k;
    }

    @Override
    public void split(Iterator<T> i) {
        this.subpops = new ArrayList<List<T>>();
        Iterator<List<T>> j = new SubpopSorter<T>(this.random, i).subpopIterator();
        while (j.hasNext()) {
            this.subpops.add(j.next());
        }
    }

    @Override
    public int getNumPartitions() {
        return this.folds;
    }

    @Override
    public Iterator<T> getTrain(int k) {
        ArrayList trainList = new ArrayList();
        for (int i = 0; i < this.subpops.size(); ++i) {
            if (i % this.folds == k) continue;
            trainList.addAll(this.subpops.get(i));
        }
        return trainList.iterator();
    }

    @Override
    public Iterator<T> getTest(int k) {
        ArrayList testList = new ArrayList();
        for (int i = 0; i < this.subpops.size(); ++i) {
            if (i % this.folds != k) continue;
            testList.addAll(this.subpops.get(i));
        }
        return testList.iterator();
    }

    public String toString() {
        return "[" + this.folds + "-CV splitter]";
    }
}

