/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.sequential.BatchSegmenterLearner;
import edu.cmu.minorthird.classify.sequential.SegmentDataset;
import edu.cmu.minorthird.classify.sequential.SegmentTransform;
import edu.cmu.minorthird.classify.sequential.Segmenter;
import edu.cmu.minorthird.classify.sequential.TransformingSegmenter;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.classify.transform.LeaveOneOutDictTransformLearner;

public class LeaveOneOutDictVersion
implements BatchSegmenterLearner {
    private String[] featurePattern;
    private BatchSegmenterLearner innerLearner;
    private String distanceNames;

    public LeaveOneOutDictVersion(String[] featurePattern, BatchSegmenterLearner innerLearner, String distanceNames) {
        this.featurePattern = featurePattern;
        this.innerLearner = innerLearner;
        this.distanceNames = distanceNames;
    }

    public LeaveOneOutDictVersion(BatchSegmenterLearner innerLearner, String distanceNames) {
        this(LeaveOneOutDictTransformLearner.DEFAULT_PATTERN, innerLearner, distanceNames);
    }

    public LeaveOneOutDictVersion(BatchSegmenterLearner innerLearner) {
        this(LeaveOneOutDictTransformLearner.DEFAULT_PATTERN, innerLearner, "Jaccard");
    }

    public void setSchema(ExampleSchema schema) {
    }

    public Segmenter batchTrain(SegmentDataset dataset) {
        LeaveOneOutDictTransformLearner transformLearner = new LeaveOneOutDictTransformLearner(this.featurePattern, this.distanceNames);
        InstanceTransform transform = transformLearner.batchTrain(dataset);
        SegmentTransform segmentTransform = new SegmentTransform(transform);
        SegmentDataset transformedDataset = segmentTransform.transform(dataset);
        Segmenter segmenter = this.innerLearner.batchTrain(transformedDataset);
        return new TransformingSegmenter(transform, segmenter);
    }
}

