/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.FeatureFactory;
import edu.cmu.minorthird.classify.GUI;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.sequential.InstanceFromSequence;
import edu.cmu.minorthird.classify.sequential.SequenceConstants;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.Visible;
import edu.cmu.minorthird.util.gui.ZoomedViewer;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDataset
implements Dataset,
SequenceConstants,
Visible,
Saveable {
    protected List<Example[]> sequenceList = new ArrayList<Example[]>();
    protected int totalSize = 0;
    private int historyLength = 1;
    private String[] history = new String[this.historyLength];
    protected Set<String> classNameSet = new HashSet<String>();
    protected FeatureFactory factory = new FeatureFactory();
    private static final String FORMAT_NAME = "Minorthird Sequential Dataset";

    @Override
    public FeatureFactory getFeatureFactory() {
        return this.factory;
    }

    public void setHistorySize(int k) {
        this.historyLength = k;
        this.history = new String[this.historyLength];
    }

    public int getHistorySize() {
        return this.historyLength;
    }

    @Override
    public ExampleSchema getSchema() {
        ExampleSchema schema = new ExampleSchema(this.classNameSet.toArray(new String[this.classNameSet.size()]));
        if (schema.equals(ExampleSchema.BINARY_EXAMPLE_SCHEMA)) {
            return ExampleSchema.BINARY_EXAMPLE_SCHEMA;
        }
        return schema;
    }

    @Override
    public void add(Example example) {
        this.addSequence(new Example[]{example});
    }

    @Override
    public void add(Example example, boolean compress) {
        this.addSequence(new Example[]{example}, compress);
    }

    public void addSequence(Example[] sequence) {
        this.addSequence(sequence, true);
    }

    public void addSequence(Example[] sequence, boolean compress) {
        if (compress) {
            Example[] compressedSeq = new Example[sequence.length];
            for (int i = 0; i < sequence.length; ++i) {
                compressedSeq[i] = this.factory.compress(sequence[i]);
                this.classNameSet.addAll(sequence[i].getLabel().possibleLabels());
            }
            this.sequenceList.add(compressedSeq);
        } else {
            this.sequenceList.add(sequence);
        }
        this.totalSize += sequence.length;
    }

    @Override
    public Iterator<Example> iterator() {
        return new MyIterator();
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    public int numberOfSequences() {
        return this.sequenceList.size();
    }

    public Iterator<Example[]> sequenceIterator() {
        return this.sequenceList.iterator();
    }

    @Override
    public void shuffle(Random r) {
        Collections.shuffle(this.sequenceList, r);
    }

    @Override
    public void shuffle() {
        this.shuffle(new Random(0L));
    }

    @Override
    public Dataset shallowCopy() {
        SequenceDataset copy2 = new SequenceDataset();
        copy2.setHistorySize(this.getHistorySize());
        Iterator<Example[]> i = this.sequenceList.iterator();
        while (i.hasNext()) {
            copy2.addSequence(i.next());
        }
        return copy2;
    }

    @Override
    public Dataset.Split split(Splitter<Example> splitter) {
        throw new UnsupportedOperationException("Use splitSequence instead.");
    }

    public Dataset.Split splitSequence(final Splitter<Example[]> splitter) {
        splitter.split(this.sequenceList.iterator());
        return new Dataset.Split(){

            public int getNumPartitions() {
                return splitter.getNumPartitions();
            }

            public Dataset getTrain(int k) {
                return SequenceDataset.this.invertIteration(splitter.getTrain(k));
            }

            public Dataset getTest(int k) {
                return SequenceDataset.this.invertIteration(splitter.getTest(k));
            }
        };
    }

    protected Dataset invertIteration(Iterator<Example[]> i) {
        SequenceDataset copy2 = new SequenceDataset();
        copy2.setHistorySize(this.getHistorySize());
        while (i.hasNext()) {
            Example[] o = i.next();
            copy2.addSequence(o);
        }
        return copy2;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[SeqData:\n");
        for (Example[] seq : this.sequenceList) {
            for (int j = 0; j < seq.length; ++j) {
                buf.append(" " + seq[j]);
            }
            buf.append("\n");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    @Override
    public String getExtensionFor(String s) {
        return ".seqdata";
    }

    @Override
    public void saveAs(File file, String format) throws IOException {
        if (!format.equals(FORMAT_NAME)) {
            throw new IllegalArgumentException("illegal format " + format);
        }
        DatasetLoader.saveSequence(this, file);
    }

    @Override
    public Object restore(File file) throws IOException {
        try {
            return DatasetLoader.loadSequence(file);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("error loading from " + file + ": " + ex);
        }
    }

    @Override
    public Viewer toGUI() {
        MyDataViewer dbGui = new MyDataViewer();
        dbGui.setContent(this);
        Viewer seqGui = GUI.newSourcedExampleViewer();
        return new ZoomedViewer(dbGui, seqGui);
    }

    public static void main(String[] args) throws IOException {
        SequenceDataset d = SampleDatasets.makeToySequenceData();
        System.out.println(d.toString());
        new ViewerFrame("Sequence data", d.toGUI());
        if (args.length > 0) {
            DatasetLoader.saveSequence(d, new File(args[0]));
        }
    }

    public int getNumPosExamples() {
        return -1;
    }

    private static class MyDataViewer
    extends ComponentViewer {
        static final long serialVersionUID = 20080207L;

        private MyDataViewer() {
        }

        public JComponent componentFor(Object o) {
            SequenceDataset d = (SequenceDataset)o;
            final Example[] arr = new Example[d.size()];
            int k = 0;
            Iterator<Example> i = d.iterator();
            while (i.hasNext()) {
                arr[k++] = i.next();
            }
            JList<Example> jList = new JList<Example>(arr);
            jList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList el, Object v, int index, boolean sel, boolean focus) {
                    return GUI.conciseExampleRendererComponent(arr[index], 100, sel);
                }
            });
            this.monitorSelections(jList);
            return new JScrollPane(jList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator
    implements Iterator<Example> {
        private Iterator<Example[]> i;
        private Example[] buf;
        private int j;

        public MyIterator() {
            this.i = SequenceDataset.this.sequenceList.iterator();
            this.buf = this.i.hasNext() ? this.i.next() : new Example[0];
            this.j = 0;
        }

        @Override
        public boolean hasNext() {
            return this.j < this.buf.length || this.i.hasNext();
        }

        @Override
        public Example next() {
            if (this.j >= this.buf.length) {
                this.buf = this.i.next();
                this.j = 0;
            }
            InstanceFromSequence.fillHistory(SequenceDataset.this.history, this.buf, this.j);
            Example e = this.buf[this.j++];
            if (e == null) {
                throw new IllegalStateException("null example at pos " + this.j + " buf " + StringUtil.toString(this.buf));
            }
            return new Example(new InstanceFromSequence(e, SequenceDataset.this.history), e.getLabel());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }
    }
}

