/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.sequential;

import edu.cmu.minorthird.classify.sequential.HMM;
import edu.cmu.minorthird.classify.sequential.HMMAlgo;
import edu.cmu.minorthird.classify.sequential.Traceback2;
import java.util.ArrayList;

public class Viterbi
extends HMMAlgo {
    double[][] v;
    Traceback2[][] B;
    Traceback2 B0;

    public Viterbi(HMM hmm, String[] x) {
        super(hmm, x);
        int i;
        int L2 = x.length;
        this.v = new double[L2 + 1][hmm.nstate];
        this.B = new Traceback2[L2 + 1][hmm.nstate];
        this.v[0][0] = 0.0;
        for (int k = 1; k < hmm.nstate; ++k) {
            this.v[0][k] = Double.NEGATIVE_INFINITY;
        }
        for (i = 1; i <= L2; ++i) {
            this.v[i][0] = Double.NEGATIVE_INFINITY;
        }
        for (i = 1; i <= L2; ++i) {
            for (int ell = 0; ell < hmm.nstate; ++ell) {
                int kmax = 0;
                double maxprod = this.v[i - 1][kmax] + hmm.loga[kmax][ell];
                for (int k = 1; k < hmm.nstate; ++k) {
                    double prod = this.v[i - 1][k] + hmm.loga[k][ell];
                    if (!(prod > maxprod)) continue;
                    kmax = k;
                    maxprod = prod;
                }
                this.v[i][ell] = hmm.loge[ell][Integer.parseInt(x[i - 1])] + maxprod;
                this.B[i][ell] = new Traceback2(i - 1, kmax);
            }
        }
        int kmax = 0;
        double max = this.v[L2][kmax];
        for (int k = 1; k < hmm.nstate; ++k) {
            if (!(this.v[L2][k] > max)) continue;
            kmax = k;
            max = this.v[L2][k];
        }
        this.B0 = new Traceback2(L2, kmax);
    }

    public String[] getPath() {
        ArrayList<StringBuffer> p = new ArrayList<StringBuffer>();
        Traceback2 tb = this.B0;
        int i = tb.i;
        int j = tb.j;
        int idx = 0;
        while ((tb = this.B[tb.i][tb.j]) != null) {
            StringBuffer tt = new StringBuffer();
            tt.append(this.hmm.state[j]);
            p.add(tt.reverse());
            ++idx;
            i = tb.i;
            j = tb.j;
        }
        String[] y = new String[p.size()];
        for (i = 0; i < p.size(); ++i) {
            y[i] = ((StringBuffer)p.get(i)).toString();
            System.out.println("y[" + i + "] is now " + y[i]);
        }
        return y;
    }
}

