/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.BasicFeatureIndex;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.ExampleSchema;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.classify.transform.InstanceTransformLearner;
import edu.cmu.minorthird.classify.transform.T1InstanceTransform;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class T1InstanceTransformLearner
implements InstanceTransformLearner {
    private double REF_LENGTH = 100.0;
    private String PDF = "Poisson";

    @Override
    public void setSchema(ExampleSchema schema) {
        if (!ExampleSchema.BINARY_EXAMPLE_SCHEMA.equals(schema)) {
            throw new IllegalStateException("can only learn binary example data");
        }
    }

    @Override
    public InstanceTransform batchTrain(Dataset dataset) {
        T1InstanceTransform T1Filter = new T1InstanceTransform();
        BasicFeatureIndex index = new BasicFeatureIndex(dataset);
        double featurePrior = 1.0 / (double)index.numberOfFeatures();
        Iterator<Feature> i = index.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            double[] xPos = new double[index.size(f, "POS")];
            double[] omegaPos = new double[index.size(f, "POS")];
            int position = 0;
            for (int j = 0; j < index.size(f); ++j) {
                Example e = index.getExample(f, j);
                if (!"POS".equals(e.getLabel().bestClassName())) continue;
                xPos[position] = e.getWeight(f);
                omegaPos[position] = this.getLength(e) / this.REF_LENGTH;
                ++position;
            }
            double[] xNeg = new double[index.size(f, "NEG")];
            double[] omegaNeg = new double[index.size(f, "NEG")];
            position = 0;
            for (int j = 0; j < index.size(f); ++j) {
                Example e = index.getExample(f, j);
                if (!"NEG".equals(e.getLabel().bestClassName())) continue;
                xNeg[position] = e.getWeight(f);
                omegaNeg[position] = this.getLength(e) / this.REF_LENGTH;
                ++position;
            }
            T1Filter.setT1(f, this.T1((int)index.getCounts(f, "POS"), (int)index.getCounts(f, "NEG")));
            if (this.PDF.equals("Poisson")) {
                double muPos = this.MaximumLikelihoodPoisson(xPos, omegaPos, featurePrior);
                double muNeg = this.MaximumLikelihoodPoisson(xNeg, omegaNeg, featurePrior);
                T1Filter.setPosMu(f, muPos);
                T1Filter.setNegMu(f, muNeg);
                T1Filter.setFeaturePdf(f, "Poisson");
                continue;
            }
            if (!this.PDF.equals("Negative-Binomial")) continue;
            SortedMap<String, Double> mudeltaPos = this.MethodOfMomentsNegBin(xPos, omegaPos, featurePrior);
            SortedMap<String, Double> mudeltaNeg = this.MethodOfMomentsNegBin(xNeg, omegaNeg, featurePrior);
            T1Filter.setPosMu(f, (Double)mudeltaPos.get("mu"));
            T1Filter.setPosDelta(f, (Double)mudeltaPos.get("delta"));
            T1Filter.setNegMu(f, (Double)mudeltaNeg.get("mu"));
            T1Filter.setNegDelta(f, (Double)mudeltaNeg.get("delta"));
            if ((Double)mudeltaPos.get("delta") == 0.0 || (Double)mudeltaNeg.get("delta") == 0.0) {
                T1Filter.setFeaturePdf(f, "Poisson");
                continue;
            }
            T1Filter.setFeaturePdf(f, "Negative-Binomial");
        }
        return T1Filter;
    }

    public double getLength(Example e) {
        double len = 0.0;
        Iterator<Feature> i = e.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            len += e.getWeight(f);
        }
        return len;
    }

    public double T1(int x1, int x2) {
        double dx1 = new Integer(x1).doubleValue();
        double dx2 = new Integer(x2).doubleValue();
        double t = Math.pow(dx1 - dx2, 2.0) / (dx1 + dx2);
        return t;
    }

    public double MaximumLikelihoodPoisson(double[] x, double[] omega, double prior) {
        double sumX = 0.0;
        double sumOmega = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sumX += x[i];
            sumOmega += omega[i];
        }
        double mu = sumX == 0.0 && sumOmega == 0.0 ? prior / (1.0 / this.REF_LENGTH) : (sumX + prior) / (sumOmega + 1.0 / this.REF_LENGTH);
        return mu;
    }

    public SortedMap<String, Double> MethodOfMomentsNegBin(double[] x, double[] omega, double prior) {
        double j = x.length;
        double sumX = 0.0;
        double sumOmega = 0.0;
        double sumOmega2 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sumX += x[i];
            sumOmega += omega[i];
            sumOmega2 += Math.pow(omega[i], 2.0);
        }
        double mu = sumX == 0.0 && sumOmega == 0.0 ? prior / (1.0 / this.REF_LENGTH) : (sumX + prior) / (sumOmega + 1.0 / this.REF_LENGTH);
        double r = j <= 1.0 ? 0.0 : (sumOmega - sumOmega2 / sumOmega) / (j - 1.0);
        double v = 0.0;
        for (int i = 0; i < x.length; ++i) {
            v += omega[i] * Math.pow(x[i] / omega[i] - mu, 2.0) / (j - 1.0);
        }
        if (j <= 1.0) {
            v = 0.0;
        }
        double d = Math.max(0.0, (v - mu) / (r * mu));
        TreeMap<String, Double> mudelta = new TreeMap<String, Double>();
        mudelta.put("mu", new Double(mu));
        mudelta.put("delta", new Double(d));
        return mudelta;
    }

    public void setREF_LENGTH(double desiredLength) {
        this.REF_LENGTH = desiredLength;
    }

    public void setPDF(String pdf) {
        this.PDF = pdf;
    }

    public static void main(String[] args) {
        Dataset dataset = SampleDatasets.sampleData("movies", false);
        T1InstanceTransformLearner learner = new T1InstanceTransformLearner();
        learner.setREF_LENGTH(100.0);
        learner.setPDF("Poisson");
        InstanceTransform filter = learner.batchTrain(dataset);
        ((T1InstanceTransform)filter).setALPHA(0.05);
        ((T1InstanceTransform)filter).setMIN_WORDS(50);
        ((T1InstanceTransform)filter).setSAMPLE(10000);
        dataset = filter.transform(dataset);
        System.out.println("new data:\n" + dataset);
    }
}

