/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Dependencies {
    private static Logger log = Logger.getLogger(Dependencies.class);
    private static String configFile = "annotators.config";
    private static Properties providerProps;

    public static void runDependency(MonotonicTextLabels labels, String reqAnnotation, String file) {
        log.debug("runDependency : " + reqAnnotation + " : " + file);
        try {
            if (file == null) {
                file = Dependencies.getDependency(reqAnnotation);
            }
            if (file == null) {
                throw new Exception("no annotator found for '" + reqAnnotation + "'");
            }
            if (file.endsWith("mixup")) {
                File f = new File(file);
                InputStream inStream = f.exists() ? new FileInputStream(f) : Dependencies.class.getClassLoader().getResourceAsStream(file);
                log.debug("got stream " + inStream);
                byte[] chars = new byte[inStream.available()];
                inStream.read(chars);
                String program = new String(chars);
                log.info("Evaluating mixup program " + file + " to provide " + reqAnnotation);
                MixupProgram subProgram = new MixupProgram(program);
                MixupInterpreter interp = new MixupInterpreter(subProgram);
                interp.eval(labels);
                if (!labels.isAnnotatedBy(reqAnnotation)) {
                    throw new IllegalArgumentException("file " + file + " did not provide expected annotation type " + reqAnnotation);
                }
            } else {
                Class<?> clazz = Dependencies.class.getClassLoader().loadClass(file);
                Annotator annotator = (Annotator)clazz.newInstance();
                annotator.annotate(labels);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            IllegalStateException exc = new IllegalStateException("error running mixup: " + file + ": " + e.getMessage());
            exc.setStackTrace(e.getStackTrace());
            throw exc;
        }
        catch (Mixup.ParseException e) {
            IllegalStateException exc = new IllegalStateException("error running mixup: " + file + ": " + e.getMessage());
            exc.setStackTrace(e.getStackTrace());
            throw exc;
        }
        catch (Exception e) {
            IllegalStateException exc = file != null ? new IllegalStateException("error loading " + file + ": " + e.getMessage()) : new IllegalStateException("error loading annotator: " + e.getMessage());
            exc.setStackTrace(e.getStackTrace());
            throw exc;
        }
    }

    protected static String getDependency(String reqAnnotation) throws IOException {
        if (providerProps == null) {
            InputStream inStream = Dependencies.class.getClassLoader().getResourceAsStream(configFile);
            log.debug("in stream = " + inStream);
            if (inStream == null) {
                throw new IllegalStateException("can't find " + configFile + " on classpath");
            }
            providerProps = new Properties();
            providerProps.load(inStream);
        }
        return providerProps.getProperty(reqAnnotation, reqAnnotation + ".mixup");
    }
}

