/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.CompoundTokenizer;
import edu.cmu.minorthird.text.Document;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBaseManager;
import edu.cmu.minorthird.text.TextToken;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class FilterTokenizer
extends CompoundTokenizer {
    private static Logger log = Logger.getLogger(FilterTokenizer.class);
    private TextBaseManager textBaseManager;
    private String parentLevelName;
    private String levelName;

    public FilterTokenizer(TextBaseManager tbMan, String levelName, String parentLevelName) {
        this.textBaseManager = tbMan;
        this.levelName = levelName;
        this.parentLevelName = parentLevelName;
        this.parentTokenizer = tbMan.getTextBase(parentLevelName).getTokenizer();
    }

    public String[] splitIntoTokens(String string2) {
        return this.parentTokenizer.splitIntoTokens(string2);
    }

    public TextToken[] splitIntoTokens(Document document) {
        Span matchingParentSpan = this.textBaseManager.getMatchingSpan(this.levelName, document.getId(), 0, document.getText().length(), this.parentLevelName);
        if (matchingParentSpan != null) {
            TreeSet<TextToken> tokens = new TreeSet<TextToken>();
            int currOffset = 0;
            for (int i = 0; i < matchingParentSpan.size(); ++i) {
                TextToken currParentToken = matchingParentSpan.getTextToken(i);
                currOffset = currParentToken.getLo() - matchingParentSpan.getTextToken(0).getLo();
                tokens.add(new TextToken(document, currOffset, currParentToken.getLength()));
            }
            return tokens.toArray(new TextToken[0]);
        }
        log.warn("Matching span could not be found for document span for doc: " + document);
        return this.parentTokenizer.splitIntoTokens(document);
    }
}

