/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text;

import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.CharAnnotation;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import java.util.Iterator;

public abstract class StringAnnotator
extends AbstractAnnotator {
    protected String providedAnnotation = null;

    protected void doAnnotate(MonotonicTextLabels labels) {
        TextBase textBase = labels.getTextBase();
        Iterator<Span> it = textBase.documentSpanIterator();
        while (it.hasNext()) {
            Span span = it.next();
            String spanString = span.asString();
            CharAnnotation[] annotations = this.annotateString(spanString);
            if (annotations == null) continue;
            for (int i = 0; i < annotations.length; ++i) {
                CharAnnotation ann = annotations[i];
                int lo = ann.getOffset();
                Span newSpan = span.charIndexSubSpan(lo, lo + ann.getLength());
                labels.addToType(newSpan, ann.getType());
            }
        }
        if (this.providedAnnotation != null) {
            labels.setAnnotatedBy(this.providedAnnotation);
        }
    }

    protected String[] closedTypes() {
        return null;
    }

    protected abstract CharAnnotation[] annotateString(String var1);
}

