/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.gui.SpanPainter;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.gui.ViewerTracker;
import edu.cmu.minorthird.text.learn.ClassifierAnnotator;
import edu.cmu.minorthird.text.learn.OnlineTextClassifierLearner;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.filechooser.FileFilter;

public class OnlineClassifierDocumentEditor
extends ViewerTracker {
    static final long serialVersionUID = 20080314L;
    public static final String LABEL_DOCUMENT = "-choose label-";
    private String importType;
    private String exportType;
    private JLabel ioTypeLabel;
    private boolean readOnly = false;
    private OnlineTextClassifierLearner textLearner = null;
    private String[] spanTypes = null;
    public OnlineClassifierDocumentEditor ocdEditor;
    private TextBaseViewer tbViewer = null;
    public List<EditedSpan> editedSpans = null;
    public ClassifierAnnotator ann = null;
    JComboBox labelBox = new JComboBox();
    JButton addButton = new JButton(new AddSelection("Add Doc(s)"));
    JButton classifierButton = new JButton(new GetClassifier("Show Classifier"));
    JButton saveAnnButton = new JButton(new SaveAnnotator("Save TextLearner"));
    JButton resetButton = new JButton(new Reset("Reset"));
    JButton completeButton = new JButton(new CompleteTraining("Complete Training"));
    JButton thisUpButton = new JButton(new MoveOnlineDocumentCursor("Up", -1));
    JButton thisDownButton = new JButton(new MoveOnlineDocumentCursor("Down", 1));
    private List<JButton> buttonsThatChangeStuff = new ArrayList<JButton>();

    public OnlineClassifierDocumentEditor(OnlineTextClassifierLearner learner, TextLabels viewLabels, TextBaseViewer tbViewer, MutableTextLabels editLabels, JList documentList, SpanPainter spanPainter, StatusMessage statusMsg) {
        super(viewLabels, editLabels, documentList, spanPainter, statusMsg);
        this.textLearner = learner;
        this.ann = this.textLearner.getAnnotator();
        this.editLabels = editLabels;
        TextBase tb = editLabels.getTextBase();
        this.spanTypes = learner.getTypes();
        this.editedSpans = new ArrayList<EditedSpan>();
        int index = 0;
        Iterator<Span> j = tb.documentSpanIterator();
        while (j.hasNext()) {
            Span s = j.next();
            for (int x = 0; x < this.spanTypes.length; ++x) {
                if (!editLabels.hasType(s, this.spanTypes[x])) continue;
                this.editedSpans.add(new EditedSpan(s, this.spanTypes[x], index));
            }
            ++index;
        }
        this.tbViewer = tbViewer;
        this.init();
        this.ocdEditor = this;
    }

    private void init() {
        this.exportType = null;
        this.importType = null;
        this.ioTypeLabel = new JLabel("Types: [None/None]");
        this.initLayout();
        for (int i = 0; i < this.spanTypes.length; ++i) {
            this.labelBox.addItem(this.spanTypes[i]);
        }
        this.labelBox.addActionListener(new LabelDocument("Label Document"));
        this.loadSpan(this.nullSpan());
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        int col = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        ++col;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.thisUpButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.thisDownButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.labelBox.addItem(LABEL_DOCUMENT);
        this.add((Component)this.labelBox, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.addButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.classifierButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.saveAnnButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.resetButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.completeButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = 2;
        this.add((Component)this.saveButton, gbc);
        this.buttonsThatChangeStuff.add(this.saveButton);
        this.saveButton.setEnabled(this.saveAsFile != null);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = col;
        this.add((Component)this.editorHolder, gbc);
    }

    public void setReadOnly(boolean readOnly) {
        for (JButton button : this.buttonsThatChangeStuff) {
            button.setEnabled(!readOnly);
        }
        this.readOnly = readOnly;
    }

    public void setTypesBeingEdited(String inType, String outType) {
        this.importType = inType;
        this.exportType = outType;
        this.ioTypeLabel.setText("Edit: " + this.importType + "/" + this.exportType);
    }

    protected void loadSpanHook() {
        if (this.readOnly && !"***dummy id***".equals(this.documentSpan.getDocumentId())) {
            this.importDocumentListMarkup(this.documentSpan.getDocumentId());
        }
    }

    public void saveAnn(File file, String format) throws IOException {
        try {
            try {
                IOUtil.saveSerialized((Serializable)((Object)this.textLearner), file);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + file + ": " + e);
            }
        }
        catch (Exception e) {
            System.out.println("Error Opening Excel File");
            e.printStackTrace();
        }
    }

    protected void documentMessage(int nextCursor) {
        if (nextCursor > -1) {
            String label = this.checkLabel(nextCursor);
            if (this.checkIfAdded(nextCursor)) {
                this.statusMsg.display("Cannot change label: Document has already been added to Classifier as: " + label);
                this.labelBox.setSelectedItem(label);
            } else if (label != null) {
                this.statusMsg.display("Document is currently labeled: " + label);
                this.labelBox.setSelectedItem(label);
            } else {
                this.statusMsg.display("In MOVEDOCCURSOI: This document has NOT been labeled");
                this.labelBox.setSelectedItem(LABEL_DOCUMENT);
            }
        }
    }

    protected void loadSpan(Span span) {
        super.loadSpan(span);
        this.documentMessage(this.documentList.getMinSelectionIndex());
    }

    public boolean checkIfAdded(int docID) {
        for (int i = 0; i < this.editedSpans.size(); ++i) {
            EditedSpan eSpan = this.editedSpans.get(i);
            if (eSpan.id != docID || !eSpan.added) continue;
            return true;
        }
        return false;
    }

    public String checkLabel(int docID) {
        for (int i = 0; i < this.editedSpans.size(); ++i) {
            EditedSpan eSpan = this.editedSpans.get(i);
            if (eSpan.id != docID) continue;
            return eSpan.label;
        }
        return null;
    }

    public boolean editDocument(Span s, String label, int docID) {
        for (int i = 0; i < this.editedSpans.size(); ++i) {
            EditedSpan eSpan = this.editedSpans.get(i);
            if (eSpan.id != docID) continue;
            if (eSpan.added) {
                return false;
            }
            eSpan.label = label;
            return true;
        }
        EditedSpan eSpan = new EditedSpan(s, label, docID);
        this.editedSpans.add(eSpan);
        return true;
    }

    public void AddDocuments() {
        EditedSpan eSpan;
        for (int i = 0; i < this.editedSpans.size(); ++i) {
            eSpan = this.editedSpans.get(i);
            if (eSpan.added || eSpan.s == null) continue;
            this.editLabels.addToType(eSpan.s, eSpan.label);
            this.textLearner.addDocument(eSpan.label, eSpan.s.asString());
        }
        for (int j = 0; j < this.editedSpans.size(); ++j) {
            eSpan = this.editedSpans.get(j);
            eSpan.add();
        }
        this.ann = this.textLearner.getAnnotator();
        this.viewLabels = this.textLearner.annotatedCopy(this.editLabels);
        this.tbViewer.updateTextLabels(this.viewLabels);
    }

    public class EditedSpan {
        public Span s;
        public String label;
        public int id;
        public boolean added = false;

        public EditedSpan(Span s, String label, int id) {
            this.s = s;
            this.label = label;
            this.id = id;
        }

        public void add() {
            this.added = true;
        }
    }

    protected class MoveOnlineDocumentCursor
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;
        private int delta;

        public MoveOnlineDocumentCursor(String msg, int delta) {
            super(msg);
            this.delta = delta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            int nextCursor;
            JList jList = OnlineClassifierDocumentEditor.this.documentList;
            synchronized (jList) {
                int currentCursor = OnlineClassifierDocumentEditor.this.documentList.getSelectedIndex();
                if (currentCursor < 0) {
                    currentCursor = 0;
                }
                if ((nextCursor = currentCursor + this.delta) < OnlineClassifierDocumentEditor.this.documentList.getModel().getSize() && nextCursor >= 0) {
                    OnlineClassifierDocumentEditor.this.documentList.setSelectedIndex(nextCursor);
                }
            }
            OnlineClassifierDocumentEditor.this.documentMessage(nextCursor);
        }
    }

    private class CompleteTraining
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public CompleteTraining(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            OnlineClassifierDocumentEditor.this.textLearner.completeTraining();
            OnlineClassifierDocumentEditor.this.statusMsg.display("Training Completed - no more examples will be added");
        }
    }

    private class Reset
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public Reset(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            OnlineClassifierDocumentEditor.this.textLearner.reset();
            OnlineClassifierDocumentEditor.this.statusMsg.display("Learner Reset - previous examples forgotten");
        }
    }

    private class SaveAnnotator
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public SaveAnnotator(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(OnlineClassifierDocumentEditor.this.ocdEditor);
            if (returnVal == 0) {
                try {
                    FileFilter filter = chooser.getFileFilter();
                    String ext = ".ann";
                    File file0 = chooser.getSelectedFile();
                    File file = file0.getName().endsWith(ext) ? file0 : new File(file0.getParentFile(), file0.getName() + ext);
                    OnlineClassifierDocumentEditor.this.ocdEditor.saveAnn(file, filter.getDescription());
                }
                catch (Exception ex) {
                    OnlineClassifierDocumentEditor.this.statusMsg.display("Error Saving Annotator");
                }
            }
        }
    }

    private class GetClassifier
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public GetClassifier(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            new ViewerFrame("Classifier", new SmartVanillaViewer(OnlineClassifierDocumentEditor.this.textLearner.getClassifier()));
            OnlineClassifierDocumentEditor.this.statusMsg.display("Getting the Classifier");
        }
    }

    private class AddSelection
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public AddSelection(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            OnlineClassifierDocumentEditor.this.AddDocuments();
            ((OnlineClassifierDocumentEditor)OnlineClassifierDocumentEditor.this).tbViewer.highlightAction.paintDocument(null);
            OnlineClassifierDocumentEditor.this.statusMsg.display("Documents added to learner");
        }
    }

    private class LabelDocument
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public LabelDocument(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            JComboBox cb = (JComboBox)event.getSource();
            String type = (String)cb.getSelectedItem();
            int docIndex = OnlineClassifierDocumentEditor.this.documentList.getMinSelectionIndex();
            if (type != OnlineClassifierDocumentEditor.LABEL_DOCUMENT) {
                if (OnlineClassifierDocumentEditor.this.editDocument(OnlineClassifierDocumentEditor.this.documentSpan, type, docIndex)) {
                    OnlineClassifierDocumentEditor.this.statusMsg.display("Document labeled: " + type);
                } else {
                    OnlineClassifierDocumentEditor.this.statusMsg.display("Document label cannot be changed - document already added");
                }
            } else {
                OnlineClassifierDocumentEditor.this.statusMsg.display("Document has NOT been labeled");
            }
        }
    }
}

