/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.gui.SpanPainter;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.gui.ViewerTracker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;

public class SpanLabeler
extends ViewerTracker {
    static final long serialVersionUID = 200803014L;
    private static final String LABEL_PROP = "userLabel";
    private static final String NULL_TYPE = "- pick label -";
    private static final String UNKNOWN_TYPE = "- unknown -";
    final JLabel currentTypeLabel = new JLabel("- unknown -");
    final JComboBox typeBox = new LabelChooserBox();
    final JButton addCurrentTypeButton = new JButton(new AddCurrentTypeAction("Accept class:"));
    final JTextField newTypeField = new JTextField(15);
    final JButton addNewTypeButton = new JButton(new AddNewTypeAction("New class:"));
    private TextBaseViewer viewer = null;

    public SpanLabeler(TextLabels viewLabels, MutableTextLabels editLabels, JList documentList, SpanPainter spanPainter, StatusMessage statusMsg) {
        super(viewLabels, editLabels, documentList, spanPainter, statusMsg);
        this.setViewEntireDocument(true);
        this.newTypeField.addActionListener(this.addNewTypeButton.getAction());
        this.restoreLabelProps();
        this.setLayout(new GridBagLayout());
        int col = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 2.0;
        gbc.weighty = 0.0;
        ++col;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.currentTypeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.addCurrentTypeButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.typeBox, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.addNewTypeButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.newTypeField, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.upButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col++;
        gbc.gridy = 2;
        this.add((Component)this.downButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = 2;
        this.add((Component)this.saveButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = col;
        this.add((Component)this.editorHolder, gbc);
        this.loadSpan(this.nullSpan());
    }

    private void restoreLabelProps() {
        Iterator<Span> i = this.editLabels.getTextBase().documentSpanIterator();
        while (i.hasNext()) {
            Span s = i.next();
            for (String t : this.editLabels.getTypes()) {
                if (!this.editLabels.hasType(s, t)) continue;
                this.editLabels.setProperty(s, LABEL_PROP, t);
            }
        }
    }

    protected void loadSpanHook() {
        String oldLabel = this.editLabels.getProperty(this.documentSpan, LABEL_PROP);
        if (oldLabel == null) {
            this.currentTypeLabel.setText(UNKNOWN_TYPE);
        } else {
            this.currentTypeLabel.setText(oldLabel);
        }
    }

    public void addViewer(TextBaseViewer viewer) {
        this.viewer = viewer;
    }

    private void setDocumentType(String type) {
        this.statusMsg.display("setting type=" + type + "for " + this.documentSpan);
        this.currentTypeLabel.setText(type);
        String oldLabel = this.editLabels.getProperty(this.documentSpan, LABEL_PROP);
        if (oldLabel != null) {
            this.editLabels.defineTypeInside(oldLabel, this.documentSpan, Collections.EMPTY_SET.iterator());
        }
        this.editLabels.setProperty(this.documentSpan, LABEL_PROP, type);
        this.editLabels.addToType(this.documentSpan, type);
        this.editLabels.closeTypeInside(type, this.documentSpan);
    }

    private class LabelChooserBox
    extends JComboBox {
        static final long serialVersionUID = 200803014L;

        public LabelChooserBox() {
            this.addItem(SpanLabeler.NULL_TYPE);
            Iterator<String> i = SpanLabeler.this.editLabels.getTypes().iterator();
            while (i.hasNext()) {
                this.addItem(i.next());
            }
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    String t = (String)LabelChooserBox.this.getSelectedItem();
                    if (!SpanLabeler.NULL_TYPE.equals(t)) {
                        SpanLabeler.this.setDocumentType(t);
                    }
                }
            });
        }
    }

    private class AddCurrentTypeAction
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public AddCurrentTypeAction(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            String type = (String)SpanLabeler.this.typeBox.getSelectedItem();
            if (!SpanLabeler.NULL_TYPE.equals(type)) {
                SpanLabeler.this.setDocumentType(type);
            }
        }
    }

    private class AddNewTypeAction
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;

        public AddNewTypeAction(String msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent event) {
            String type = SpanLabeler.this.newTypeField.getText().trim();
            if (!SpanLabeler.this.editLabels.isType(type)) {
                SpanLabeler.this.typeBox.addItem(type);
                if (SpanLabeler.this.viewer != null) {
                    SpanLabeler.this.viewer.getGuessBox().addItem(type);
                    SpanLabeler.this.viewer.getTruthBox().addItem(type);
                    SpanLabeler.this.viewer.getDisplayedTypeBox().addItem(type);
                }
            }
            SpanLabeler.this.setDocumentType(type);
        }
    }
}

