/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.util.Iterator;

public class SampleExtractionProblem {
    private static String[] trainStrings = new String[]{"Hello there, William Cohen, and welcome to CMU.", "William Clinton is a former US president.", "There's a new book by Hillary Clinton.", "George Washington was father of our country.", "Where in the world is Carmen Sandiego?", "Which George Bush was most damaging to the economy?", "I love books about Curious George the monkey."};
    private static String[] testStrings = new String[]{"Does William Cohen rock or what?", "Say what you like, William Clinton definitely had bad hair", "Who was George Mason anyway? did he invent jars?", "Don't blame me, I never voted for anyone named George Bush"};
    public static final String LABEL = "trueName";
    private static String[] labelingProgram = new String[]{"defTokenProp cap:t =: ... [re('^[A-Z][a-z]+')] ...", "defSpanType trueName =~ trie William Cohen,William Clinton,Hillary Clinton,George Washington,Carmen Sandiego,George Bush,Curious George,George Mason", "defSpanType bigram =: ... [any any] ... ", "defSpanProp inCapsBecause:name =: ... [@trueName] ...", "defSpanProp inCapsBecause:start =: [any]...@trueName...", "defSpanType inCapsBecauseStart =: [any]...@trueName...", "defSpanType political =: [ ... 'Clinton' ... ] || [... 'George' 'Bush' ...]", "defSpanProp subject:politics =: [@political]", "defSpanProp subject:me =: [...'William' 'Cohen'...]", "defSpanProp subject:other =top- [@political] || [...'William' 'Cohen'...]"};

    public static TextLabels trainLabels() {
        try {
            BasicTextBase base = SampleExtractionProblem.trainBase();
            BasicTextLabels labels = new BasicTextLabels(base);
            MixupProgram prog = new MixupProgram(labelingProgram);
            MixupInterpreter interp = new MixupInterpreter(prog);
            interp.eval(labels);
            Iterator<Span> i = base.documentSpanIterator();
            while (i.hasNext()) {
                labels.closeTypeInside(LABEL, i.next());
            }
            new TextLabelsLoader().closeLabels(labels, 1);
            return labels;
        }
        catch (Mixup.ParseException e) {
            throw new IllegalStateException("error: " + e);
        }
    }

    public static TextLabels taggerTrainLabels() {
        return SampleExtractionProblem.tagNames(SampleExtractionProblem.trainLabels());
    }

    public static TextLabels taggerTestLabels() {
        return SampleExtractionProblem.tagNames(SampleExtractionProblem.testLabels());
    }

    private static TextLabels tagNames(TextLabels labels) {
        try {
            NestedTextLabels labels1 = new NestedTextLabels(labels);
            MixupProgram p = new MixupProgram(new String[]{"defTokenProp partOfName:true =: ... [@trueName] ... "});
            MixupInterpreter interp = new MixupInterpreter(p);
            interp.eval(labels1);
            return labels1;
        }
        catch (Mixup.ParseException e) {
            throw new IllegalStateException("error: " + e);
        }
    }

    public static BasicTextBase trainBase() {
        BasicTextBase base = new BasicTextBase();
        for (int i = 0; i < trainStrings.length; ++i) {
            base.loadDocument("trainStrings[" + i + "]", trainStrings[i]);
        }
        return base;
    }

    public static TextLabels testLabels() {
        try {
            BasicTextBase base = SampleExtractionProblem.testBase();
            BasicTextLabels labels = new BasicTextLabels(base);
            MixupProgram prog = new MixupProgram(labelingProgram);
            MixupInterpreter interp = new MixupInterpreter(prog);
            interp.eval(labels);
            new TextLabelsLoader().closeLabels(labels, 1);
            return labels;
        }
        catch (Mixup.ParseException e) {
            throw new IllegalStateException("error: " + e);
        }
    }

    public static BasicTextBase testBase() {
        BasicTextBase base = new BasicTextBase();
        for (int i = 0; i < testStrings.length; ++i) {
            base.loadDocument("testStrings[" + i + "]", testStrings[i]);
        }
        return base;
    }
}

