/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.BinaryClassifier;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.text.AbstractAnnotator;
import edu.cmu.minorthird.text.Details;
import edu.cmu.minorthird.text.MixupFinder;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanFinder;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.ExtractorAnnotator;
import edu.cmu.minorthird.text.learn.FilteredFinder;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.util.ProgressCounter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartEndLengthAnnotator
extends AbstractAnnotator
implements ExtractorAnnotator {
    private double threshold = 0.5;
    private static final SpanFinder tokenFinder;
    private LengthScorer lengthScorer;
    private SpanFeatureExtractor fe;
    private BinaryClassifier start;
    private BinaryClassifier end;
    private String annotationType;

    public StartEndLengthAnnotator(BinaryClassifier start, BinaryClassifier end, SpanFeatureExtractor fe, Map<Integer, Integer> lengthMap, int totalPosSpans, String annotationType) {
        this.fe = fe;
        this.start = start;
        this.end = end;
        this.lengthScorer = new LengthScorer(lengthMap, totalPosSpans);
        this.annotationType = annotationType;
    }

    public void setThreshold(double t) {
        this.threshold = t;
    }

    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public String getSpanType() {
        return this.annotationType;
    }

    public SpanFinder getStartFinder() {
        return new FilteredFinder(this.start, this.fe, tokenFinder);
    }

    public SpanFinder getEndFinder() {
        return new FilteredFinder(this.end, this.fe, tokenFinder);
    }

    @Override
    protected void doAnnotate(MonotonicTextLabels labels) {
        Iterator<Span> i = labels.getTextBase().documentSpanIterator();
        ProgressCounter pc = new ProgressCounter("annotate", "document");
        while (i.hasNext()) {
            int j;
            Span document = i.next();
            double[] startPred = new double[document.size()];
            double[] endPred = new double[document.size()];
            for (j = 0; j < document.size(); ++j) {
                Span tokenSpan = document.subSpan(j, 1);
                Instance instance = this.fe.extractInstance(labels, tokenSpan);
                startPred[j] = this.start.score(instance);
                endPred[j] = this.end.score(instance);
            }
            for (j = 0; j <= document.size() - 1; ++j) {
                double startScore = startPred[j];
                if (startScore < this.threshold) continue;
                for (int len = 1; j + len <= document.size() && len <= this.lengthScorer.maxLength(); ++len) {
                    double lengthScore = this.lengthScorer.score(len);
                    if (lengthScore + startScore < this.threshold) continue;
                    double endScore = endPred[j + len - 1];
                    double finalScore = startScore + lengthScore + endScore;
                    String lContext = document.subSpan(Math.max(0, j - 5), Math.min(5, j - Math.max(0, j - 5))).asString();
                    String rContext = document.subSpan(j + len, Math.min(5, document.size() - j - len)).asString();
                    String cContext = document.subSpan(j, len).asString();
                    if (!(finalScore > this.threshold)) continue;
                    System.out.println("output [" + finalScore + "] " + lContext + "|" + cContext + "|" + rContext);
                    TreeMap<String, Double> m = new TreeMap<String, Double>();
                    m.put("start", new Double(startPred[j]));
                    m.put("end", new Double(endPred[j + len - 1]));
                    m.put("length", new Double(lengthScore));
                    labels.addToType(document.subSpan(j, len), this.annotationType, new Details(finalScore, m));
                }
            }
            pc.progress();
        }
        pc.finished();
    }

    @Override
    public String explainAnnotation(TextLabels labels, Span documentSpan) {
        return "not implemented";
    }

    public String toString() {
        return "[StartEndLen: " + this.start + ";" + this.end + ";" + this.lengthScorer + "]";
    }

    static {
        try {
            tokenFinder = new MixupFinder(new Mixup("...[any]..."));
        }
        catch (Mixup.ParseException e) {
            throw new IllegalStateException("illegal tokenFinder");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LengthScorer {
        private Map<Integer, Integer> lengthFreqMap;
        private int numLengths;
        private double mixingFactor = 0.1;
        private int maxLength = 0;

        public LengthScorer(Map<Integer, Integer> lengthFreqMap, int totalPosSpans) {
            this.lengthFreqMap = lengthFreqMap;
            this.numLengths = totalPosSpans;
            for (int len : lengthFreqMap.keySet()) {
                this.maxLength = Math.max(this.maxLength, len);
            }
        }

        public int maxLength() {
            return this.maxLength;
        }

        public double score(int len) {
            Integer freq = this.lengthFreqMap.get(new Integer(len));
            double empiricalProb = freq == null ? 0.0 : (double)freq.intValue() / (double)this.numLengths;
            double smoothedProb = this.mixingFactor / (double)this.maxLength + (1.0 - this.mixingFactor) * empiricalProb;
            double odds = Math.log(smoothedProb / (1.0 - smoothedProb));
            return odds;
        }

        public String toString() {
            return "[LengthScorer: " + this.maxLength + ";" + this.lengthFreqMap + "]";
        }
    }
}

