/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.AnnotationExample;
import edu.cmu.minorthird.text.learn.AnnotatorTeacher;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLabelsAnnotatorTeacher
extends AnnotatorTeacher {
    private TextLabels labels;
    private String userLabelType;
    private String userLabelProp;

    public TextLabelsAnnotatorTeacher(TextLabels labels, String userLabelType) {
        this(labels, userLabelType, null);
    }

    public TextLabelsAnnotatorTeacher(TextLabels labels, String userLabelType, String userLabelProp) {
        this.labels = labels;
        this.userLabelType = userLabelType;
        this.userLabelProp = userLabelProp;
    }

    @Override
    public Iterator<Span> documentPool() {
        return this.labels.getTextBase().documentSpanIterator();
    }

    @Override
    public AnnotationExample labelInstance(Span query) {
        if (query.documentSpanStartIndex() != 0 || query.size() != query.documentSpan().size()) {
            throw new IllegalArgumentException("can't label a partial document");
        }
        AnnotationExample example = new AnnotationExample(query, this.labels, this.userLabelType, this.userLabelProp);
        return example;
    }

    @Override
    public boolean hasAnswers() {
        return true;
    }

    @Override
    public TextLabels availableLabels() {
        return this.labels;
    }
}

