/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.mixup;

import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.BoneheadStemmer;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.Token;
import edu.cmu.minorthird.util.ProgressCounter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mixup
implements Serializable {
    private static final long serialVersionUID = 20080303L;
    public static int minMatchesToApplyConstraints = 5000;
    public static int maxNumberOfMatchesPerToken = 5;
    public static int maxNumberOfMatches = 0x8000000;
    private static final boolean DEBUG = false;
    public static final Pattern tokenizerPattern = Pattern.compile("\\s*((\\n)|(\\w+)|(\\/\\/)|('(\\\\'|[^\\'])*')|\\&\\&|\\|\\||\\.\\.\\.|\\\\\\;|\\W)\\s*");
    private static Set<String> legalFunctions = new HashSet<String>();
    private static final int RE = 0;
    private static final int EQ = 1;
    private static final int EQI = 2;
    private static final int A = 3;
    private static final int AI = 4;
    private static final int ANY = 5;
    private static final int PROP = 6;
    private static final int PROPDICT = 7;
    private static final int ELIPSE = 9;
    private Expr expr;

    public Mixup(String pattern) throws ParseException {
        MixupTokenizer tok = new MixupTokenizer(pattern);
        if (tok.advance()) {
            this.expr = new MixupParser(tok).parseExpr();
        }
    }

    public Mixup(MixupTokenizer tok) throws ParseException {
        this.expr = new MixupParser(tok).parseExpr();
    }

    public Iterator<Span> extract(TextLabels labels, Iterator<Span> spanLooper) {
        return this.expr.match(labels, spanLooper);
    }

    public String toString() {
        return this.expr.toString();
    }

    public static void main(String[] args) {
        try {
            Mixup mixup = new Mixup(args[0]);
            System.out.println("normalized expression = " + mixup);
            BasicTextBase b = new BasicTextBase();
            BasicTextLabels labels = new BasicTextLabels(b);
            for (int i = 1; i < args.length; ++i) {
                b.loadDocument("arg_" + i, args[i]);
            }
            new BoneheadStemmer().stem(b, labels);
            Iterator<Span> i = mixup.extract(labels, b.documentSpanIterator());
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        String[] tmp = new String[]{"re", "eq", "eqi", "a", "ai", "any", "prop", "propDict"};
        for (int i = 0; i < tmp.length; ++i) {
            legalFunctions.add(tmp[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Expr
    implements Serializable {
        private static final long serialVersionUID = 20080303L;
        private BasicExpr expr1;
        private Expr expr2;
        private String op;

        public Expr(BasicExpr expr1, Expr expr2, String op) {
            this.expr1 = expr1;
            this.expr2 = expr2;
            this.op = op;
        }

        public Iterator<Span> match(TextLabels labels, Iterator<Span> spanIt) {
            if (this.expr2 == null) {
                return this.expr1.match(labels, spanIt);
            }
            if ("&&".equals(this.op)) {
                return this.expr2.match(labels, this.expr1.match(labels, spanIt));
            }
            if (!"||".equals(this.op)) {
                throw new IllegalStateException("illegal operator '" + this.op + "'");
            }
            TreeSet<Span> save = new TreeSet<Span>();
            while (spanIt.hasNext()) {
                save.add(spanIt.next());
            }
            Iterator<Span> a = this.expr1.match(labels, save.iterator());
            Iterator<Span> b = this.expr2.match(labels, save.iterator());
            TreeSet<Span> union = new TreeSet<Span>();
            while (a.hasNext()) {
                union.add(a.next());
            }
            while (b.hasNext()) {
                union.add(b.next());
            }
            return union.iterator();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.expr1.toString());
            if (this.expr2 != null) {
                buf.append(" " + this.op + " " + this.expr2.toString());
            }
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BasicExpr
    implements Serializable {
        private static final long serialVersionUID = 20080303L;
        public final Expr expr;
        public final RepeatedPrim[] repPrim;
        public final int leftBracket;
        public final int rightBracket;
        private static Logger log = Logger.getLogger(BasicExpr.class);

        public BasicExpr(Expr expr) {
            this.expr = expr;
            this.repPrim = null;
            this.rightBracket = -1;
            this.leftBracket = -1;
        }

        public BasicExpr(RepeatedPrim[] repPrim, int leftBracket, int rightBracket) {
            this.expr = null;
            this.repPrim = repPrim;
            this.leftBracket = leftBracket;
            this.rightBracket = rightBracket;
        }

        public String toString() {
            if (this.expr != null) {
                return "(" + this.expr.toString() + ")";
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.repPrim.length; ++i) {
                if (i == this.leftBracket) {
                    buf.append("[");
                }
                buf.append(" " + this.repPrim[i].toString());
                if (i + 1 != this.rightBracket) continue;
                buf.append("]");
            }
            return buf.toString();
        }

        public Iterator<Span> match(TextLabels labels, Iterator<Span> spanLooper) {
            if (this.expr != null) {
                return this.expr.match(labels, spanLooper);
            }
            ProgressCounter pc = new ProgressCounter("mixup", "span");
            TreeSet<Span> accum = new TreeSet<Span>();
            while (spanLooper.hasNext()) {
                pc.progress();
                Span span = spanLooper.next();
                this.fastMatch(labels, span, accum);
            }
            pc.finished();
            return accum.iterator();
        }

        private void fastMatch(TextLabels labels, Span span, Set<Span> accum) {
            log.debug("matching span id/size=" + span.getDocumentId() + "/" + span.size());
            log.debug("before alloc: max/free=" + Runtime.getRuntime().maxMemory() + "/" + Runtime.getRuntime().freeMemory());
            int maxRepeatedPrimMatches = span.size() > Integer.MAX_VALUE / (span.size() + 1) ? Integer.MAX_VALUE : span.size() * (span.size() + 1);
            if (maxRepeatedPrimMatches > minMatchesToApplyConstraints) {
                if (maxNumberOfMatchesPerToken > 0 && span.size() > Integer.MAX_VALUE / maxNumberOfMatchesPerToken) {
                    maxRepeatedPrimMatches = Math.min(maxNumberOfMatchesPerToken * span.size(), maxRepeatedPrimMatches);
                }
                if (maxNumberOfMatches > 0 && maxNumberOfMatches < maxRepeatedPrimMatches) {
                    maxRepeatedPrimMatches = maxNumberOfMatches;
                }
            }
            int[] loIndexBuffer = new int[maxRepeatedPrimMatches];
            int[] lengthBuffer = new int[maxRepeatedPrimMatches];
            log.debug("alloc hi-lo: max/free=" + Runtime.getRuntime().maxMemory() + "/" + Runtime.getRuntime().freeMemory());
            int[][] possibleLos = new int[this.repPrim.length][];
            int[][] possibleLens = new int[this.repPrim.length][];
            int[] minLen = new int[this.repPrim.length];
            int[] maxLen = new int[this.repPrim.length];
            boolean[] isAny = new boolean[this.repPrim.length];
            log.debug("after alloc: max/free=" + Runtime.getRuntime().maxMemory() + "/" + Runtime.getRuntime().freeMemory());
            for (int i = 0; i < this.repPrim.length; ++i) {
                RepeatedPrim rp = this.repPrim[i];
                minLen[i] = rp.minCount;
                maxLen[i] = span.size();
                if (rp.maxCount >= 0 && rp.maxCount < maxLen[i]) {
                    maxLen[i] = rp.maxCount;
                }
                if (rp.primList.size() == 1) {
                    Prim prim = rp.primList.get(0);
                    boolean bl = isAny[i] = 5 == prim.function && !prim.negated && !rp.leftMost && !rp.rightMost;
                }
                if (isAny[i]) continue;
                int numMatches = 0;
                if (rp.type != null) {
                    Iterator<Span> el = labels.instanceIterator(rp.type, span.getDocumentId());
                    while (el.hasNext()) {
                        if (numMatches >= maxRepeatedPrimMatches) {
                            this.overflowWarning(numMatches, maxRepeatedPrimMatches, span, i);
                            return;
                        }
                        Span s = el.next();
                        if (!span.contains(s)) continue;
                        if (numMatches >= maxRepeatedPrimMatches) {
                            this.overflowWarning(numMatches, maxRepeatedPrimMatches, span, i);
                            return;
                        }
                        loIndexBuffer[numMatches] = s.documentSpanStartIndex() - span.documentSpanStartIndex();
                        lengthBuffer[numMatches] = s.size();
                        ++numMatches;
                    }
                }
                if (rp.type == null || rp.type != null && rp.minCount == 0) {
                    for (int j = 0; j <= span.size(); ++j) {
                        int topLen = Math.min(maxLen[i], span.size() - j);
                        for (int k = minLen[i]; k <= topLen; ++k) {
                            if (numMatches >= maxRepeatedPrimMatches) {
                                this.overflowWarning(numMatches, maxRepeatedPrimMatches, span, i);
                                return;
                            }
                            if (!rp.matchesSubspan(labels, span, j, k)) continue;
                            loIndexBuffer[numMatches] = j;
                            lengthBuffer[numMatches] = k;
                            ++numMatches;
                        }
                    }
                }
                possibleLos[i] = new int[numMatches];
                possibleLens[i] = new int[numMatches];
                for (int m = 0; m < numMatches; ++m) {
                    possibleLos[i][m] = loIndexBuffer[m];
                    possibleLens[i][m] = lengthBuffer[m];
                }
            }
            int[] lows = new int[this.repPrim.length];
            int[] highs = new int[this.repPrim.length];
            this.fastMatch(labels, accum, span, lows, highs, 1, 0, 0, possibleLos, possibleLens, isAny, minLen, maxLen);
        }

        private void overflowWarning(int numMatches, int maxRepeatedPrimMatches, Span span, int i) {
            log.warn("mixup warning at pattern #" + (i + 1) + " " + this.repPrim[i] + ") on " + span);
            log.warn("not enough room to store all matches: adjust Mixup.maxNumberOfMatches(PerToken)");
            log.warn("size=" + span.size() + " numMatches=" + numMatches + " max=" + maxRepeatedPrimMatches + " minConstraint=" + minMatchesToApplyConstraints);
        }

        private void fastMatch(TextLabels labels, Set<Span> accum, Span span, int[] lows, int[] highs, int tab, int spanCursor, int patternCursor, int[][] possibleLos, int[][] possibleLens, boolean[] isAny, int[] minLen, int[] maxLen) {
            block8: {
                block7: {
                    if (patternCursor != this.repPrim.length) break block7;
                    if (spanCursor != span.size()) break block8;
                    int lo = lows[this.leftBracket];
                    int hi = highs[this.rightBracket - 1];
                    accum.add(span.subSpan(lo, hi - lo));
                    break block8;
                }
                if (isAny[patternCursor]) {
                    if (patternCursor + 1 < this.repPrim.length && !isAny[patternCursor + 1]) {
                        for (int i = 0; i < possibleLos[patternCursor + 1].length; ++i) {
                            int nextSpanCursor = possibleLos[patternCursor + 1][i];
                            int len = nextSpanCursor - spanCursor;
                            if (len < minLen[patternCursor] || len > maxLen[patternCursor]) continue;
                            lows[patternCursor] = spanCursor;
                            highs[patternCursor] = spanCursor + len;
                            this.fastMatch(labels, accum, span, lows, highs, tab + 1, spanCursor + len, patternCursor + 1, possibleLos, possibleLens, isAny, minLen, maxLen);
                        }
                    } else {
                        int topLen = Math.min(maxLen[patternCursor], span.size() - spanCursor);
                        for (int len = minLen[patternCursor]; len <= topLen; ++len) {
                            lows[patternCursor] = spanCursor;
                            highs[patternCursor] = spanCursor + len;
                            this.fastMatch(labels, accum, span, lows, highs, tab + 1, spanCursor + len, patternCursor + 1, possibleLos, possibleLens, isAny, minLen, maxLen);
                        }
                    }
                } else {
                    int topLen = span.size() - spanCursor;
                    for (int i = 0; i < possibleLos[patternCursor].length; ++i) {
                        if (possibleLos[patternCursor][i] != spanCursor || possibleLens[patternCursor][i] > topLen) continue;
                        int len = possibleLens[patternCursor][i];
                        lows[patternCursor] = spanCursor;
                        highs[patternCursor] = spanCursor + len;
                        this.fastMatch(labels, accum, span, lows, highs, tab + 1, spanCursor + len, patternCursor + 1, possibleLos, possibleLens, isAny, minLen, maxLen);
                    }
                }
            }
        }

        private void showMatch(int tab, String msg, Span span, int[] lows, int[] highs, int patternCursor) {
            int i;
            for (i = 0; i < tab; ++i) {
                System.out.print("| ");
            }
            System.out.print(msg + ":");
            for (i = 0; i < patternCursor; ++i) {
                System.out.print(" " + this.repPrim[i].toString() + "[" + lows[i] + ":" + highs[i] + "]<");
                for (int j = lows[i]; j < highs[i]; ++j) {
                    if (j > lows[i]) {
                        System.out.print(" ");
                    }
                    System.out.print(span.getToken(j).getValue());
                }
                System.out.print(">");
            }
            System.out.println();
        }
    }

    private static class RepeatedPrim
    implements Serializable {
        private static final long serialVersionUID = 20080303L;
        public boolean leftMost = false;
        public boolean rightMost = false;
        public List<Prim> primList = new ArrayList<Prim>();
        public boolean[] whereIMatch;
        public Span whatIIndexed = null;
        public int minCount;
        public int maxCount;
        String type = null;

        private RepeatedPrim() {
        }

        public void expandShortcuts() {
            if (this.primList.size() == 1) {
                Prim prim = this.primList.get(0);
                if (9 == prim.function) {
                    prim.function = 5;
                    prim.funcString = "any";
                    this.minCount = 0;
                    this.maxCount = -1;
                    return;
                }
            }
        }

        public boolean checkFunction() {
            for (Prim prim : this.primList) {
                if ("...".equals(prim.funcString) && this.primList.size() != 1) {
                    return false;
                }
                if (prim.checkFunction()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            if (this.type != null) {
                if (this.minCount == 0) {
                    return "@" + this.type + "?";
                }
                return "@" + this.type;
            }
            StringBuffer buf = new StringBuffer("");
            if (this.leftMost) {
                buf.append("L ");
            }
            if (this.primList.size() == 1) {
                buf.append(this.primList.get(0));
            } else {
                if (this.primList.size() == 0) {
                    throw new IllegalStateException("empty prim list");
                }
                buf.append("<" + this.primList.get(0).toString());
                for (int i = 1; i < this.primList.size(); ++i) {
                    buf.append(", " + this.primList.get(i).toString());
                }
                buf.append(">");
            }
            buf.append("{" + this.minCount + "," + this.maxCount + "}");
            if (this.rightMost) {
                buf.append("R");
            }
            return buf.toString();
        }

        public void index(Span s, TextLabels labels) {
            this.whatIIndexed = s;
            this.whereIMatch = new boolean[s.size()];
            for (int i = 0; i < s.size(); ++i) {
                this.whereIMatch[i] = this.matchesPrimList(labels, s.getToken(i));
            }
        }

        public boolean matchesSubspan(TextLabels labels, Span span, int lo, int len) {
            if (this.type != null) {
                if (this.minCount == 1) {
                    return labels.hasType(span.subSpan(lo, len), this.type);
                }
                return len == 0 || labels.hasType(span.subSpan(lo, len), this.type);
            }
            if (this.whatIIndexed == null || !this.whatIIndexed.equals(span)) {
                this.index(span, labels);
            }
            if (len > this.maxCount && this.maxCount >= 0) {
                return false;
            }
            if (len < this.minCount) {
                return false;
            }
            int spanSize = span.size();
            for (int i = lo; i < lo + len; ++i) {
                if (i >= spanSize) {
                    return false;
                }
                if (this.whereIMatch[i]) continue;
                return false;
            }
            if (this.leftMost && (len < this.maxCount || this.maxCount < 0) && lo > 0 && this.whereIMatch[lo - 1]) {
                return false;
            }
            return !this.rightMost || len >= this.maxCount && this.maxCount >= 0 || lo + len >= spanSize || !this.whereIMatch[lo + len];
        }

        private boolean matchesPrimList(TextLabels labels, Token token) {
            for (Prim prim : this.primList) {
                if (prim.matchesPrim(labels, token)) continue;
                return false;
            }
            return true;
        }
    }

    private static class Prim
    implements Serializable {
        private static final long serialVersionUID = 20080303L;
        public boolean negated = false;
        public int function = -1;
        public String funcString = "";
        public String argument = "";
        public String property = "";
        public String value = "";
        private Pattern pattern = null;

        private Prim() {
        }

        public boolean matchesPrim(TextLabels labels, Token token) {
            boolean status = this.matchesUnnegatedPrim(labels, token);
            return this.negated == !status;
        }

        private boolean matchesUnnegatedPrim(TextLabels labels, Token token) {
            if (this.function == 3) {
                return labels.inDict(token, this.argument);
            }
            if (this.function == 1) {
                return token.getValue().equals(this.argument);
            }
            if (this.function == 4) {
                final String lc = token.getValue().toLowerCase();
                Token lcToken = new Token(){

                    public String toString() {
                        return "[lcToken " + lc + "]";
                    }

                    public String getValue() {
                        return lc;
                    }
                };
                return labels.inDict(lcToken, this.argument);
            }
            if (this.function == 0) {
                return this.pattern.matcher(token.getValue()).find();
            }
            if (this.function == 5) {
                return true;
            }
            if (this.function == 2) {
                return token.getValue().equalsIgnoreCase(this.argument);
            }
            if (this.function == 6) {
                return this.value.equals(labels.getProperty(token, this.property));
            }
            if (this.function == 7) {
                final String propVal = labels.getProperty(token, this.property);
                if (propVal == null) {
                    return false;
                }
                Token propValToken = new Token(){

                    public String toString() {
                        return "[token:" + propVal + "]";
                    }

                    public String getValue() {
                        return propVal;
                    }
                };
                return labels.inDict(propValToken, this.value);
            }
            throw new IllegalStateException("illegal function '" + this.funcString + "'");
        }

        public void expandShortcuts() {
            if (this.funcString.startsWith("'") && this.funcString.endsWith("'")) {
                this.argument = this.funcString;
                this.function = 1;
                this.funcString = "eq";
            }
            if (this.argument.startsWith("'") && this.argument.endsWith("'")) {
                this.argument = this.argument.substring(1, this.argument.length() - 1);
                this.argument = this.argument.replaceAll("\\\\'", "'");
            }
            if (0 == this.function) {
                this.pattern = Pattern.compile(this.argument);
            }
        }

        public boolean checkFunction() {
            return legalFunctions.contains(this.funcString);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("");
            if (this.negated) {
                buf.append("!");
            }
            if (6 != this.function) {
                buf.append(this.funcString);
                if (this.argument != null) {
                    buf.append("(" + this.argument + ")");
                }
            } else {
                buf.append(this.property + ":" + this.value);
            }
            return buf.toString();
        }
    }

    public static class ParseException
    extends Exception {
        static final long serialVersionUID = 20080303L;

        public ParseException(String s) {
            super(s);
        }
    }

    private static class MixupParser {
        private MixupTokenizer tok;

        public MixupParser(MixupTokenizer tok) {
            this.tok = tok;
        }

        public Expr parse() throws ParseException {
            return this.parseExpr();
        }

        private Expr parseExpr() throws ParseException {
            Expr expr2 = null;
            String op = null;
            BasicExpr basic = this.parseBasicExpr();
            if ("&&".equals(this.tok.token) || "||".equals(this.tok.token)) {
                op = this.tok.token;
                this.tok.advance();
                expr2 = this.parseExpr();
            }
            return new Expr(basic, expr2, op);
        }

        private BasicExpr parseBasicExpr() throws ParseException {
            ArrayList<RepeatedPrim> list = new ArrayList<RepeatedPrim>();
            int left = -1;
            int right = -1;
            if ("(".equals(this.tok.token)) {
                this.tok.advance();
                Expr expr = this.parseExpr();
                if (!")".equals(this.tok.token)) {
                    this.tok.parseError("expected close paren");
                }
                this.tok.advance();
                return new BasicExpr(expr);
            }
            while (!(this.tok.token == null || "||".equals(this.tok.token) || "&&".equals(this.tok.token) || ")".equals(this.tok.token))) {
                if ("[".equals(this.tok.token)) {
                    left = list.size();
                    this.tok.advance();
                    continue;
                }
                if ("]".equals(this.tok.token)) {
                    right = list.size();
                    this.tok.advance();
                    continue;
                }
                list.add(this.parseRepeatedPrim());
            }
            if (left < 0) {
                this.tok.parseError("no left bracket");
            }
            if (right < 0) {
                this.tok.parseError("no right bracket");
            }
            return new BasicExpr(list.toArray(new RepeatedPrim[list.size()]), left, right);
        }

        private RepeatedPrim parseRepeatedPrim() throws ParseException {
            RepeatedPrim buf = new RepeatedPrim();
            if ("@".equals(this.tok.token)) {
                this.tok.advance();
                buf.type = this.tok.token;
                this.tok.advance();
                buf.maxCount = 1;
                if ("?".equals(this.tok.token)) {
                    buf.minCount = 0;
                    this.tok.advance();
                } else {
                    buf.minCount = 1;
                }
                return buf;
            }
            if ("L".equals(this.tok.token)) {
                buf.leftMost = true;
                this.tok.advance();
            }
            this.parsePrim(buf);
            this.parseRepeat(buf);
            if ("R".equals(this.tok.token)) {
                buf.rightMost = true;
                this.tok.advance();
            }
            buf.expandShortcuts();
            if (!buf.checkFunction()) {
                this.tok.parseError("syntax error");
            }
            return buf;
        }

        private void parsePrim(RepeatedPrim buf) throws ParseException {
            if ("<".equals(this.tok.token)) {
                this.tok.advance();
                this.parseSimplePrim(buf);
                while (",".equals(this.tok.token)) {
                    this.tok.advance();
                    this.parseSimplePrim(buf);
                }
                if (">".equals(this.tok.token)) {
                    this.tok.advance();
                } else {
                    this.tok.parseError("expected '>'");
                }
            } else {
                this.parseSimplePrim(buf);
            }
        }

        private void parseSimplePrim(RepeatedPrim buf) throws ParseException {
            Prim prim = new Prim();
            if ("!".equals(this.tok.token)) {
                prim.negated = true;
                this.tok.advance();
            }
            prim.funcString = this.tok.token;
            if ("a".equals(this.tok.token)) {
                prim.function = 3;
            } else if ("eq".equals(this.tok.token)) {
                prim.function = 1;
            } else if ("ai".equals(this.tok.token)) {
                prim.function = 4;
            } else if ("re".equals(this.tok.token)) {
                prim.function = 0;
            } else if ("any".equals(this.tok.token)) {
                prim.function = 5;
            } else if ("eqi".equals(this.tok.token)) {
                prim.function = 2;
            } else if ("...".equals(this.tok.token)) {
                prim.function = 9;
            } else if ("prop".equals(this.tok.token)) {
                prim.function = 6;
            } else if ("propDict".equals(this.tok.token)) {
                prim.function = 7;
            }
            this.tok.advance();
            if ("(".equals(this.tok.token)) {
                this.tok.advance();
                prim.argument = this.tok.token;
                this.tok.advance();
                if (!")".equals(this.tok.token)) {
                    this.tok.parseError("expected close paren");
                }
                this.tok.advance();
            } else if (":".equals(this.tok.token)) {
                prim.property = prim.funcString;
                prim.function = 6;
                prim.funcString = "prop";
                this.tok.advance();
                if ("a".equals(this.tok.token)) {
                    this.tok.advance();
                    if (!"(".equals(this.tok.token)) {
                        prim.value = "a";
                        this.tok.advance();
                    } else {
                        this.tok.advance();
                        prim.function = 7;
                        prim.funcString = "propDict";
                        prim.value = this.tok.token;
                        this.tok.advance();
                        if (!")".equals(this.tok.token)) {
                            this.tok.parseError("expected close paren");
                        }
                        this.tok.advance();
                    }
                } else {
                    prim.value = this.tok.token;
                    this.tok.advance();
                }
            }
            prim.expandShortcuts();
            buf.primList.add(prim);
        }

        private void parseRepeat(RepeatedPrim buf) throws ParseException {
            String min = null;
            String max = null;
            if ("{".equals(this.tok.token)) {
                this.tok.advance();
                if (!",".equals(this.tok.token)) {
                    min = this.tok.token;
                    this.tok.advance();
                } else {
                    min = "0";
                }
                if ("}".equals(this.tok.token)) {
                    max = min;
                    this.tok.advance();
                } else {
                    if (!",".equals(this.tok.token)) {
                        this.tok.parseError("expected \",\"");
                    }
                    this.tok.advance();
                    if (!"}".equals(this.tok.token)) {
                        max = this.tok.token;
                        this.tok.advance();
                    } else {
                        max = "-1";
                    }
                    if (!"}".equals(this.tok.token)) {
                        this.tok.parseError("expected \"}\"");
                    }
                    this.tok.advance();
                }
            } else if ("+".equals(this.tok.token)) {
                min = "1";
                max = "-1";
                this.tok.advance();
            } else if ("*".equals(this.tok.token)) {
                min = "0";
                max = "-1";
                this.tok.advance();
            } else if ("?".equals(this.tok.token)) {
                min = "0";
                max = "1";
                this.tok.advance();
            } else {
                max = "1";
                min = "1";
            }
            try {
                buf.minCount = Integer.parseInt(min);
                buf.maxCount = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                this.tok.parseError("expected an integer: min = '" + min + "' max='" + max + "'");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MixupTokenizer {
        public String input;
        public Matcher matcher;
        private String token;
        public String nextToken;
        private int cursor;
        public int nextCursor = 0;

        public MixupTokenizer(String input) {
            this.input = input;
            this.matcher = tokenizerPattern.matcher(input);
        }

        public boolean advance() {
            if (this.matcher.find()) {
                this.cursor = this.matcher.start(1);
                this.token = this.matcher.group(1);
                if (this.token.equals(";")) {
                    this.token = null;
                    return false;
                }
                return true;
            }
            this.token = null;
            return false;
        }

        public String advance(Set<String> set) throws ParseException {
            if (!this.matcher.find()) {
                this.token = null;
                this.cursor = this.input.length();
                return null;
            }
            this.cursor = this.matcher.start(1);
            this.token = this.matcher.group(1);
            if (this.token.equals(";")) {
                this.token = null;
                return null;
            }
            if (set != null && !set.contains(this.token)) {
                System.out.println("Token at Error: " + this.token);
                this.parseError("statement error: expected one of: " + this.setContents(set) + " in " + this.token);
            }
            return this.token;
        }

        private void parseError(String msg) throws ParseException {
            throw new ParseException(msg + ": " + this.input.substring(0, this.cursor) + "^^^" + this.input.substring(this.cursor, this.input.length()));
        }

        private String setContents(Set<String> set) {
            StringBuffer buf = new StringBuffer("");
            Iterator<String> i = set.iterator();
            while (i.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append("'" + i.next().toString() + "'");
            }
            return buf.toString();
        }
    }
}

