/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.text.Annotator;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ApplyAnnotator
extends UIMain {
    static Logger log = Logger.getLogger(ApplyAnnotator.class);
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.LoadAnnotatorParams load = new CommandLineUtil.LoadAnnotatorParams();
    private CommandLineUtil.AnnotatorOutputParams output = new CommandLineUtil.AnnotatorOutputParams();
    private TextLabels annLabels = null;

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams p) {
        this.save = p;
    }

    public CommandLineUtil.LoadAnnotatorParams getLoadAnnotatorParameters() {
        return this.load;
    }

    public void setLoadAnnotatorParameters(CommandLineUtil.LoadAnnotatorParams p) {
        this.load = p;
    }

    public CommandLineUtil.AnnotatorOutputParams getAnnotatorOutputParams() {
        return this.output;
    }

    public void setAnnotatorOutputParams(CommandLineUtil.AnnotatorOutputParams p) {
        this.output = p;
    }

    public String getApplyAnnotatorHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/ApplyAnnotator%20Tutorial.htm\">ApplyAnnotator Tutorial</A></html>";
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.load, this.output});
    }

    public void doMain() {
        block10: {
            if (this.load.loadFrom == null) {
                throw new IllegalArgumentException("-loadFrom must be specified");
            }
            Annotator ann = null;
            try {
                ann = (Annotator)((Object)IOUtil.loadSerialized(this.load.loadFrom));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("can't load annotator from " + this.load.loadFrom + ": " + ex);
            }
            this.annLabels = ann.annotatedCopy(this.base.labels);
            if (this.base.showResult) {
                new ViewerFrame("Annotated Textbase", new SmartVanillaViewer(this.annLabels));
            }
            if (this.save.saveAs != null) {
                try {
                    if ("minorthird".equals(this.output.format)) {
                        new TextLabelsLoader().saveTypesAsOps(this.annLabels, this.save.saveAs);
                        break block10;
                    }
                    if ("strings".equals(this.output.format)) {
                        new TextLabelsLoader().saveTypesAsStrings(this.annLabels, this.save.saveAs, true);
                        break block10;
                    }
                    if ("xml".equals(this.output.format)) {
                        new TextLabelsLoader().saveDocsWithEmbeddedTypes(this.annLabels, this.save.saveAs);
                        break block10;
                    }
                    throw new IllegalArgumentException("illegal output format " + this.output.format + " allowed values are " + StringUtil.toString(this.output.getAllowedOutputFormatValues()));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
                }
            }
        }
    }

    public Object getMainResult() {
        return this.annLabels;
    }

    public static void main(String[] args) {
        new ApplyAnnotator().callMain(args);
    }
}

