/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.Recommended;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;

public class PreprocessTextForClassifier
extends UIMain {
    protected String linkFileName = null;
    protected SpanFeatureExtractor fe = new Recommended.DocumentFE();
    protected CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    protected CommandLineUtil.ClassificationSignalParams signal = new CommandLineUtil.ClassificationSignalParams(this.base);
    protected Dataset dataset;

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{new LinkFileParams(), this.gui, this.base, this.signal, this.save});
    }

    public String getLinkFile() {
        return this.linkFileName;
    }

    public void setLinkFile(String s) {
        this.linkFileName = s;
    }

    public SpanFeatureExtractor getFeatureExtractor() {
        return this.fe;
    }

    public void setFeatureExtractor(SpanFeatureExtractor fe) {
        this.fe = fe;
    }

    public CommandLineUtil.ClassificationSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.ClassificationSignalParams p) {
        this.signal = p;
    }

    public void doMain() {
        if (this.signal.spanProp == null && this.signal.spanType == null) {
            throw new IllegalArgumentException("one of -spanProp or -spanType must be specified");
        }
        if (this.signal.spanProp != null && this.signal.spanType != null) {
            throw new IllegalArgumentException("only one of -spanProp or -spanType can be specified");
        }
        if (this.save.saveAs == null) {
            throw new IllegalArgumentException("-saveAs must be specified");
        }
        this.dataset = CommandLineUtil.toDataset(this.base.labels, this.fe, this.signal.spanProp, this.signal.spanType, this.signal.candidateType);
        try {
            DatasetLoader.save(this.dataset, this.save.saveAs);
        }
        catch (IOException ex) {
            System.out.println("error saving dataset to '" + this.save.saveAs + "': " + ex);
        }
        if (this.base.showResult) {
            new ViewerFrame("Dataset", this.dataset.toGUI());
        }
        if (this.linkFileName != null) {
            try {
                this.saveLinkInfo(new File(this.linkFileName), this.dataset, this.save.getSaveAs());
            }
            catch (IOException ex) {
                System.out.println("error saving link information to '" + this.linkFileName + "': " + ex);
            }
        }
    }

    private void saveLinkInfo(File linkFile, Dataset dataset, String datasetFileName) throws IOException {
        int lineNo = 0;
        PrintStream out = new PrintStream(new FileOutputStream(linkFile));
        Iterator<Example> i = dataset.iterator();
        while (i.hasNext()) {
            Example ex = i.next();
            ++lineNo;
            if (!(ex.getSource() instanceof Span)) {
                throw new IllegalArgumentException("example not associated with a span: " + ex);
            }
            Span span = (Span)ex.getSource();
            out.println(DatasetLoader.getSourceAssignedToExample(datasetFileName, lineNo) + " " + span.getDocumentId() + " " + span.getLoChar() + " " + (span.getHiChar() - span.getLoChar()));
        }
        out.close();
    }

    public Object getMainResult() {
        return this.dataset;
    }

    public static void main(String[] args) {
        new PreprocessTextForClassifier().callMain(args);
    }

    public class LinkFileParams
    extends BasicCommandLineProcessor {
        public String linkFileHelp = "file to save mapping between examples and spans they correspond to";

        public void linkFile(String s) {
            PreprocessTextForClassifier.this.linkFileName = s;
        }

        public CommandLineProcessor fe(String s) {
            PreprocessTextForClassifier.this.fe = (SpanFeatureExtractor)CommandLineUtil.newObjectFromBSH(s, SpanFeatureExtractor.class);
            return PreprocessTextForClassifier.this.fe instanceof CommandLineProcessor.Configurable ? this.tryToGetCLP(PreprocessTextForClassifier.this.fe) : null;
        }

        public CommandLineProcessor feOp() {
            return this.tryToGetCLP(PreprocessTextForClassifier.this.fe);
        }

        public void usage() {
            System.out.println("special parameters:");
            System.out.println(" [-linkFile FILE]           " + this.linkFileHelp);
            System.out.println(" [-fe beanshell]            feature extractor");
            System.out.println(" [-feOp opt1 ...]           options for feature extractor");
            System.out.println();
        }

        public String getLinkFileHelp() {
            return this.linkFileHelp;
        }
    }
}

