/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.DatasetLoader;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.learn.BeginContinueEndUniqueReduction;
import edu.cmu.minorthird.text.learn.Extraction2TaggingReduction;
import edu.cmu.minorthird.text.learn.SequenceAnnotatorLearner;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.PreprocessTextForClassifier;
import edu.cmu.minorthird.ui.Recommended;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;

public class PreprocessTextForExtractor
extends PreprocessTextForClassifier {
    protected int historySize = 1;
    protected Extraction2TaggingReduction reduction = new BeginContinueEndUniqueReduction();

    public PreprocessTextForExtractor() {
        this.fe = new Recommended.TokenFE();
    }

    public void usage() {
        System.out.println("extraction-related parameters:");
        System.out.println(" [-history N]               number of previous classes to use as features");
        System.out.println(" [-reduction beanshell]     how to map tokens to classes");
        System.out.println();
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{new PreprocessTextForClassifier.LinkFileParams(), new ExtractionReductionParams(), this.gui, this.base, this.signal, this.save});
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int n) {
        this.historySize = n;
    }

    public Extraction2TaggingReduction getReduction() {
        return this.reduction;
    }

    public void setReduction(Extraction2TaggingReduction r) {
        this.reduction = r;
    }

    public void doMain() {
        if (this.signal.spanProp == null && this.signal.spanType == null) {
            throw new IllegalArgumentException("one of -spanProp or -spanType must be specified");
        }
        if (this.signal.spanProp != null && this.signal.spanType != null) {
            throw new IllegalArgumentException("only one of -spanProp or -spanType can be specified");
        }
        if (this.save.saveAs == null) {
            throw new IllegalArgumentException("-saveAs must be specified");
        }
        this.dataset = SequenceAnnotatorLearner.prepareSequenceData(this.base.labels, this.signal.spanType, this.signal.spanProp, this.fe, this.historySize, this.reduction);
        try {
            DatasetLoader.saveSequence((SequenceDataset)this.dataset, this.save.saveAs);
        }
        catch (IOException ex) {
            System.out.println("error saving sequential dataset to '" + this.save.saveAs + "': " + ex);
        }
        if (this.base.showResult) {
            new ViewerFrame("Dataset", this.dataset.toGUI());
        }
        if (this.linkFileName != null) {
            try {
                this.saveLinkInfoSequence(new File(this.linkFileName), (SequenceDataset)this.dataset, this.save.getSaveAs());
            }
            catch (IOException ex) {
                System.out.println("error saving link information to '" + this.linkFileName + "': " + ex);
            }
        }
    }

    private void saveLinkInfoSequence(File linkFile, SequenceDataset dataset, String datasetFileName) throws IOException {
        int lineNo = 0;
        PrintStream out = new PrintStream(new FileOutputStream(linkFile));
        Iterator<Example[]> i = dataset.sequenceIterator();
        while (i.hasNext()) {
            Example[] seq = i.next();
            for (int j = 0; j < seq.length; ++j) {
                Example ex = seq[j];
                ++lineNo;
                if (!(ex.getSource() instanceof Span)) {
                    throw new IllegalArgumentException("example not associated with a span: " + ex);
                }
                Span span = (Span)ex.getSource();
                out.println(DatasetLoader.getSourceAssignedToExample(datasetFileName, lineNo) + " " + span.getDocumentId() + " " + span.getLoChar() + " " + (span.getHiChar() - span.getLoChar()));
            }
            ++lineNo;
        }
        out.close();
    }

    public static void main(String[] args) {
        new PreprocessTextForExtractor().callMain(args);
    }

    public class ExtractionReductionParams
    extends BasicCommandLineProcessor {
        public void history(String s) {
            PreprocessTextForExtractor.this.historySize = StringUtil.atoi(s);
        }

        public void reduction(String s) {
            PreprocessTextForExtractor.this.reduction = (Extraction2TaggingReduction)CommandLineUtil.newObjectFromBSH(s, Extraction2TaggingReduction.class);
        }
    }
}

