/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.experiments.ClassifiedDataset;
import edu.cmu.minorthird.classify.experiments.Evaluation;
import edu.cmu.minorthird.text.learn.ClassifierAnnotator;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.UIMain;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.JointCommandLineProcessor;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.io.IOException;

public class TestClassifier
extends UIMain {
    private CommandLineUtil.SaveParams save = new CommandLineUtil.SaveParams();
    private CommandLineUtil.ClassificationSignalParams signal = new CommandLineUtil.ClassificationSignalParams(this.base);
    private CommandLineUtil.TestClassifierParams test = new CommandLineUtil.TestClassifierParams();
    private Object result = null;

    public CommandLineUtil.SaveParams getSaveParameters() {
        return this.save;
    }

    public void setSaveParameters(CommandLineUtil.SaveParams p) {
        this.save = p;
    }

    public CommandLineUtil.ClassificationSignalParams getSignalParameters() {
        return this.signal;
    }

    public void setSignalParameters(CommandLineUtil.ClassificationSignalParams p) {
        this.signal = p;
    }

    public CommandLineUtil.TestClassifierParams getAdditionalParameters() {
        return this.test;
    }

    public void setAdditionalParameters(CommandLineUtil.TestClassifierParams p) {
        this.test = p;
    }

    public String getTestClassifierHelp() {
        return "<A HREF=\"http://minorthird.sourceforge.net/tutorials/TestClassifier%20Tutorial.htm\">TestClassifier Tutorial</A></html>";
    }

    public CommandLineProcessor getCLP() {
        return new JointCommandLineProcessor(new CommandLineProcessor[]{this.gui, this.base, this.save, this.signal, this.test});
    }

    public void doMain() {
        if (this.test.loadFrom == null) {
            throw new IllegalArgumentException("-loadFrom must be specified");
        }
        ClassifierAnnotator ann = null;
        try {
            ann = (ClassifierAnnotator)IOUtil.loadSerialized(this.test.loadFrom);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("can't load annotator from " + this.test.loadFrom + ": " + ex);
        }
        Dataset d = CommandLineUtil.toDataset(this.base.labels, ann.getFE(), this.signal.spanProp, this.signal.spanType, this.signal.candidateType);
        Evaluation evaluation = null;
        if (this.test.showData) {
            new ViewerFrame("Dataset", d.toGUI());
        }
        if (this.test.showClassifier) {
            new ViewerFrame("Classifier", new SmartVanillaViewer(ann.getClassifier()));
        }
        evaluation = new Evaluation(d.getSchema());
        evaluation.extend(ann.getClassifier(), d, 0);
        this.result = this.test.showTestDetails ? new ClassifiedDataset(ann.getClassifier(), d) : evaluation;
        if (this.base.showResult) {
            new ViewerFrame("Result", new SmartVanillaViewer(this.result));
        }
        if (this.save.saveAs != null) {
            try {
                IOUtil.saveSerialized(evaluation, this.save.saveAs);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't save to " + this.save.saveAs + ": " + e);
            }
        }
        evaluation.summarize();
    }

    public Object getMainResult() {
        return this.result;
    }

    public static void main(String[] args) {
        new TestClassifier().callMain(args);
    }
}

