/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.ui.CommandLineUtil;
import edu.cmu.minorthird.ui.InLineSelectableTypes;
import edu.cmu.minorthird.ui.SelectableTypes;
import edu.cmu.minorthird.ui.advancedParameters;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.Version;
import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.Console;
import edu.cmu.minorthird.util.gui.SmartVanillaViewer;
import edu.cmu.minorthird.util.gui.TypeSelector;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;

public abstract class UIMain
implements CommandLineProcessor.Configurable,
Console.Task {
    private JPanel errorPanel;
    public static JButton viewButton;
    public Console.Task main;
    protected CommandLineUtil.BaseParams base = new CommandLineUtil.BaseParams();
    protected CommandLineUtil.GUIParams gui = new CommandLineUtil.GUIParams();

    public CommandLineUtil.BaseParams getBaseParameters() {
        return this.base;
    }

    public void setBaseParameters(CommandLineUtil.BaseParams base) {
        this.base = base;
    }

    public void helloWorld() {
        System.out.println("hello world");
    }

    public abstract void doMain();

    public abstract Object getMainResult();

    public boolean getLabels() {
        return this.base.labels != null;
    }

    public void callMain(final String[] args) {
        try {
            CommandLineProcessor clp = this.getCLP();
            clp.processArguments(args);
            if (clp.shouldTerminate()) {
                return;
            }
            if (!this.gui.useGUI) {
                if (this.base.labels == null) {
                    throw new IllegalArgumentException("-labels must be specified");
                }
                if (this.base.showLabels) {
                    new ViewerFrame("Labeled TextBase", new SmartVanillaViewer(this.base.labels));
                }
                this.doMain();
            } else {
                this.main = this;
                ComponentViewer v = new ComponentViewer(){
                    static final long serialVersionUID = 20071024L;

                    public JComponent componentFor(Object o) {
                        TypeSelector ts = UIMain.this.base.classic ? new TypeSelector(SelectableTypes.CLASSES, "selectableTypes.txt", o.getClass()) : new TypeSelector(SelectableTypes.CLASSES, InLineSelectableTypes.CLASSES, advancedParameters.NAMES, "selectableTypes.txt", o.getClass());
                        ts.setContent(o);
                        JPanel panel = new JPanel();
                        panel.setBorder(new TitledBorder(StringUtil.toString(args, "Command line: ", "", " ")));
                        panel.setLayout(new GridBagLayout());
                        JPanel subpanel1 = new JPanel();
                        subpanel1.setBorder(new TitledBorder("Parameter modification"));
                        subpanel1.add(ts);
                        GridBagConstraints gbc = Viewer.fillerGBC();
                        gbc.weighty = 0.0;
                        panel.add((Component)subpanel1, gbc);
                        JPanel subpanel2 = new JPanel();
                        subpanel2.setBorder(new TitledBorder("Execution controls"));
                        viewButton = new JButton(new AbstractAction("View results"){
                            static final long serialVersionUID = 20071024L;

                            public void actionPerformed(ActionEvent event) {
                                SmartVanillaViewer rv = new SmartVanillaViewer();
                                rv.setContent(UIMain.this.getMainResult());
                                new ViewerFrame("Result", rv);
                            }
                        });
                        viewButton.setEnabled(false);
                        UIMain.this.errorPanel = new JPanel();
                        UIMain.this.errorPanel.setBorder(new TitledBorder("Error messages and output"));
                        final Console console = new Console(UIMain.this.main, UIMain.this.base.labels != null, viewButton);
                        UIMain.this.errorPanel.add(console.getMainComponent());
                        JButton goButton = new JButton(new AbstractAction("Start Task"){
                            static final long serialVersionUID = 20071024L;

                            public void actionPerformed(ActionEvent event) {
                                console.start();
                            }
                        });
                        JButton showLabelsButton = new JButton(new AbstractAction("Show labels"){
                            static final long serialVersionUID = 20071024L;

                            public void actionPerformed(ActionEvent ev) {
                                if (UIMain.this.base.labels == null) {
                                    UIMain.this.noLabelsMessage(console);
                                } else {
                                    new ViewerFrame("Labeled TextBase", new SmartVanillaViewer(UIMain.this.base.labels));
                                }
                            }
                        });
                        JButton clearButton = new JButton(new AbstractAction("Clear window"){
                            static final long serialVersionUID = 20071024L;

                            public void actionPerformed(ActionEvent ev) {
                                console.clear();
                            }
                        });
                        JButton helpParamsButton = new JButton(new AbstractAction("Parameters"){
                            static final long serialVersionUID = 20071024L;

                            public void actionPerformed(ActionEvent ev) {
                                PrintStream oldSystemOut = System.out;
                                ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
                                System.setOut(new PrintStream(outBuffer));
                                UIMain.this.getCLP().usage();
                                console.append(outBuffer.toString());
                                System.setOut(oldSystemOut);
                            }
                        });
                        JButton helpRepositoryButton = new JButton(new AbstractAction("Repository"){
                            static final long serialVersionUID = 20071024L;

                            public void actionPerformed(ActionEvent ev) {
                                UIMain.this.repositoryHelp(console);
                            }
                        });
                        subpanel2.add(goButton);
                        subpanel2.add(viewButton);
                        subpanel2.add(showLabelsButton);
                        subpanel2.add(clearButton);
                        subpanel2.add(new JLabel("Help:"));
                        subpanel2.add(helpParamsButton);
                        subpanel2.add(helpRepositoryButton);
                        gbc = Viewer.fillerGBC();
                        gbc.weighty = 0.0;
                        gbc.gridy = 1;
                        panel.add((Component)subpanel2, gbc);
                        gbc = Viewer.fillerGBC();
                        gbc.weighty = 1.0;
                        gbc.gridy = 2;
                        panel.add((Component)UIMain.this.errorPanel, gbc);
                        JProgressBar progressBar1 = new JProgressBar();
                        JProgressBar progressBar2 = new JProgressBar();
                        JProgressBar progressBar3 = new JProgressBar();
                        ProgressCounter.setGraphicContext(new JProgressBar[]{progressBar1, progressBar2, progressBar3});
                        gbc = Viewer.fillerGBC();
                        gbc.weighty = 0.0;
                        gbc.gridy = 3;
                        panel.add((Component)progressBar1, gbc);
                        gbc = Viewer.fillerGBC();
                        gbc.weighty = 0.0;
                        gbc.gridy = 4;
                        panel.add((Component)progressBar2, gbc);
                        gbc = Viewer.fillerGBC();
                        gbc.weighty = 0.0;
                        gbc.gridy = 5;
                        panel.add((Component)progressBar3, gbc);
                        return panel;
                    }
                };
                v.setContent(this);
                String className = this.getClass().toString().substring("class ".length());
                ViewerFrame f = new ViewerFrame(className + ":  " + Version.getVersion(), v);
                f.setDefaultCloseOperation(3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Use option -help for help");
        }
    }

    public void noLabelsMessage(Console console) {
        console.append("\nYou need to specify the labeled data you're using!\nModify the 'labels' parameters under base parameters section\nof the parameter modification window.\n");
    }

    private void repositoryHelp(Console console) {
        console.append("The Minorthird repository is a collection of data previously labeled for extraction\nor classification learning. One version of the repository containing public data is on:\n   /afs/cs/project/extract-learn/repository.\n\nYour repository is now configured as follows:\n  edu.cmu.minorthird.scriptDir => " + FancyLoader.getProperty("edu.cmu.minorthird.scriptDir") + "\n" + "  " + "edu.cmu.minorthird.dataDir" + " => " + FancyLoader.getProperty("edu.cmu.minorthird.dataDir") + "\n" + "  " + "edu.cmu.minorthird.labelDir" + " => " + FancyLoader.getProperty("edu.cmu.minorthird.labelDir") + "\n" + "To change these parameters, put new values in a file \"data.properties\" on your classpath.\n" + "\n" + "edu.cmu.minorthird.scriptDir" + " should contain bean shell scripts that return labeled datasets,\n" + "encoded as TextLabels objects. Usually these load documents from the directory pointed to by\n" + "edu.cmu.minorthird.dataDir" + " and load labels from the directory pointed to by\n" + "edu.cmu.minorthird.labelDir" + "\n\n" + "Instead of using script names from repositories as the \"keys\" for the -labels options\n" + "you can also use the name of (a) a directory containing XML-marked up data (b) the common stem\n" + "\"foo\" of a pair of files foo.base and foo.labels or (c) the common stem of a pair foo.labels\n" + "and foo, where foo is a directory.\n");
    }
}

