/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

import java.io.Serializable;

public class MathUtil {
    public static int sign(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double abs(double x) {
        if (x > 0.0) {
            return x;
        }
        return -x;
    }

    public static double logistic(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static class Accumulator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private double sum = 0.0;
        private double cov = 0.0;
        private double count = 0.0;
        private boolean isBinomial = true;

        public void add(double d) {
            this.sum += d;
            this.cov += d * d;
            this.count += 1.0;
            if (d != 0.0 && d != 1.0) {
                this.isBinomial = false;
            }
        }

        public double mean() {
            return this.sum / this.count;
        }

        public double numberOfValues() {
            return this.count;
        }

        public double variance() {
            double avg = this.mean();
            return this.cov / this.count - avg * avg;
        }

        public double populationStdDev() {
            return Math.sqrt(this.variance());
        }

        public double stdDev() {
            return this.populationStdDev() / Math.sqrt((this.count - 1.0) / this.count);
        }

        public double stdErr() {
            return this.stdDev() / Math.sqrt(this.count);
        }

        public double binomialStdErr() {
            if (!this.isBinomial) {
                throw new IllegalArgumentException("numbers in accumulator are not binomial!");
            }
            double p = this.mean();
            return Math.sqrt(p * (1.0 - p) / this.count);
        }

        public double z(double expected) {
            return (this.mean() - expected) / this.stdErr();
        }
    }
}

