/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

import java.text.DecimalFormat;
import javax.swing.JProgressBar;

public final class ProgressCounter {
    private static DecimalFormat format = new DecimalFormat("0.00");
    static JProgressBar[] graphicContext = new JProgressBar[0];
    static int currentDepth = 0;
    private static final int TIME_BTWN_OUTPUTS_IN_MS = 1000;
    private String task;
    private String step;
    private int numSteps;
    private int depth;
    private long startTime;
    private long lastOutputTime;
    private int stepsCompleted;
    private JProgressBar graphicCounter;

    public static void setGraphicContext(JProgressBar[] context) {
        graphicContext = context;
    }

    public static void clearGraphicContext() {
        graphicContext = new JProgressBar[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressCounter(String task, String step, int numSteps) {
        this.task = task;
        this.step = step;
        this.stepsCompleted = 0;
        this.numSteps = numSteps;
        this.depth = currentDepth++;
        this.startTime = this.lastOutputTime = System.currentTimeMillis();
        if (this.depth < graphicContext.length) {
            JProgressBar[] jProgressBarArray = graphicContext;
            synchronized (graphicContext) {
                this.graphicCounter = graphicContext[this.depth];
                this.graphicCounter.setValue(0);
                if (numSteps >= 0) {
                    this.graphicCounter.setMaximum(numSteps);
                }
                this.graphicCounter.setIndeterminate(numSteps < 0);
                this.graphicCounter.setString(numSteps >= 0 ? " " + task + " for " + numSteps + " " + step + "s " : task);
                this.graphicCounter.setStringPainted(true);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else {
            this.graphicCounter = null;
        }
    }

    public ProgressCounter(String task, int numSteps) {
        this(task, "step", numSteps);
    }

    public ProgressCounter(String task, String step) {
        this(task, step, -1);
    }

    public ProgressCounter(String task) {
        this(task, "step", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final synchronized void progress() {
        ++this.stepsCompleted;
        long time2 = System.currentTimeMillis();
        if (time2 - this.lastOutputTime <= 1000L) return;
        if (this.graphicCounter != null) {
            JProgressBar[] jProgressBarArray = graphicContext;
            // MONITORENTER : graphicContext
            this.graphicCounter.setValue(this.stepsCompleted);
            // MONITOREXIT : jProgressBarArray
        }
        try {
            System.out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < this.depth; ++i) {
            System.out.print("| ");
        }
        if (this.numSteps >= 0) {
            try {
                System.out.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.println("Task " + this.task + ": " + format.format(100.0 * (double)this.stepsCompleted / (double)this.numSteps) + "% (" + this.stepsCompleted + "/" + this.numSteps + " " + this.step + "s) in " + format.format((double)(time2 - this.startTime) / 1000.0) + " sec");
        } else {
            try {
                System.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Task " + this.task + ": " + this.stepsCompleted + " " + this.step + "(s) in " + format.format((double)(time2 - this.startTime) / 1000.0) + " sec");
        }
        this.lastOutputTime = time2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void finished() {
        if (this.graphicCounter != null && this.graphicCounter.isIndeterminate()) {
            JProgressBar[] jProgressBarArray = graphicContext;
            // MONITORENTER : graphicContext
            this.graphicCounter.setIndeterminate(false);
            this.graphicCounter.setMaximum(this.stepsCompleted);
            this.graphicCounter.setValue(this.stepsCompleted);
            this.graphicCounter.setStringPainted(false);
            // MONITOREXIT : jProgressBarArray
        }
        currentDepth = this.depth;
    }
}

