/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

public class StringEncoder {
    private char escapeChar;
    private String illegalChars;

    public StringEncoder(char escapeChar, String illegalChars) {
        this.escapeChar = escapeChar;
        this.illegalChars = illegalChars;
    }

    public String encode(String s) {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == this.escapeChar) {
                buf.append(this.escapeChar);
                buf.append(this.escapeChar);
                continue;
            }
            if (this.isIllegal(ch)) {
                buf.append(this.escapeChar);
                char code = ch;
                int hex1 = code / 16;
                int hex2 = code % 16;
                buf.append(Character.forDigit(hex1, 16));
                buf.append(Character.forDigit(hex2, 16));
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public String decode(String s) {
        StringBuffer buf = new StringBuffer("");
        int k = 0;
        while (k < s.length()) {
            if (s.charAt(k) != this.escapeChar) {
                buf.append(s.charAt(k));
                ++k;
                continue;
            }
            if (s.charAt(k + 1) == this.escapeChar) {
                buf.append(this.escapeChar);
                k += 2;
                continue;
            }
            int hex1 = Character.digit(s.charAt(k + 1), 16);
            int hex2 = Character.digit(s.charAt(k + 2), 16);
            buf.append((char)(hex1 * 16 + hex2));
            k += 3;
        }
        return buf.toString();
    }

    private boolean isIllegal(char c) {
        for (int i = 0; i < this.illegalChars.length(); ++i) {
            if (this.illegalChars.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        StringEncoder e = new StringEncoder('%', ".= \t");
        for (int i = 0; i < args.length; ++i) {
            System.out.println("'" + args[i] + "'\t'" + e.encode(args[i]) + "'\t'" + e.decode(e.encode(args[i])) + "'");
        }
    }
}

