/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.IndexedViewer;
import edu.cmu.minorthird.util.gui.MessageViewer;
import edu.cmu.minorthird.util.gui.ParallelViewer;
import edu.cmu.minorthird.util.gui.VanillaViewer;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import edu.cmu.minorthird.util.gui.ZoomedViewer;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextArea;

public class TestViewer {
    private static Viewer parallelStringViewer() {
        ComponentViewer lc = new ComponentViewer(){
            static final long serialVersionUID = 20080517L;

            public boolean canReceive(Object o) {
                return o instanceof String;
            }

            public JComponent componentFor(Object o) {
                String s = (String)o;
                System.out.println("converting " + s + " to lower case!");
                return new JTextArea(s.toLowerCase());
            }
        };
        ComponentViewer uc = new ComponentViewer(){
            static final long serialVersionUID = 20080517L;

            public boolean canReceive(Object o) {
                return o instanceof String;
            }

            public JComponent componentFor(Object o) {
                String s = (String)o;
                System.out.println("converting " + s + " to upper case!");
                return new JTextArea(s.toUpperCase());
            }
        };
        VanillaViewer van = new VanillaViewer();
        ParallelViewer par = new ParallelViewer();
        par.addSubView("Original", van);
        par.addSubView("LowerCase", lc);
        par.addSubView("UpperCase", uc);
        return par;
    }

    private static Viewer indexViewer() {
        final HashMap<String, String[]> m = new HashMap<String, String[]>();
        m.put("Hurst", new String[]{"Matthew", "Wakako", "Hannah"});
        m.put("Cohen", new String[]{"William", "Susan", "Joshua", "Charlie"});
        m.put("Tomikoyo", new String[]{"Takashi", "Laura", "Makoto", "TBA"});
        IndexedViewer indexViewer = new IndexedViewer(){
            static final long serialVersionUID = 20080517L;

            public Object[] indexFor(Object o) {
                this.sendSignal(2, "displaying the " + o + " family");
                return (Object[])m.get(o);
            }
        };
        ComponentViewer lnameListViewer = new ComponentViewer(){
            static final long serialVersionUID = 20080517L;

            public JComponent componentFor(Object o) {
                Object[] array = (Object[])o;
                JList<Object> jlist = new JList<Object>(array);
                this.monitorSelections(jlist);
                return jlist;
            }
        };
        lnameListViewer.setContent(m.keySet().toArray());
        ZoomedViewer familyViewer = new ZoomedViewer(indexViewer, TestViewer.parallelStringViewer());
        familyViewer.setHorizontal();
        return new MessageViewer(new ZoomedViewer(lnameListViewer, familyViewer));
    }

    public static void main(String[] argv) {
        try {
            Viewer v = TestViewer.indexViewer();
            new ViewerFrame("Test", v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

