/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import edu.cmu.minorthird.util.IOUtil;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.StringUtil;
import edu.cmu.minorthird.util.gui.Viewer;
import edu.cmu.minorthird.util.gui.Visible;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ViewerFrame
extends JFrame {
    static final long serialVersionUID = 20080517L;
    private static Logger log = Logger.getLogger(ViewerFrame.class);
    private Viewer myViewer = null;
    private String myName = null;
    private JMenuItem saveItem = null;
    private JMenuItem zoomItem = null;
    private JMenuItem openItem = null;
    private Object content = null;
    private ContentWrapper wrapper = null;

    public ViewerFrame(String name, Viewer viewer) {
        this.addMenu();
        this.setContent(name, viewer);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    private void setContent(String name, Viewer viewer) {
        this.myName = name;
        this.myViewer = viewer;
        this.content = this.myViewer.getSerializableContent();
        this.wrapper = new ContentWrapper(this.content);
        viewer.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)viewer, "Center");
        this.setTitle(name);
        this.myViewer.revalidate();
        this.zoomItem.setEnabled(this.myViewer.getSubViewNames().size() > 0);
        this.saveItem.setEnabled(this.wrapper.isSaveable());
        this.openItem.setEnabled(this.wrapper.isSaveable());
    }

    private void addMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        this.openItem = new JMenuItem("Open ...");
        menu.add(this.openItem);
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                JFileChooser chooser = ViewerFrame.this.wrapper.makeFileChooser(ViewerFrame.this.wrapper);
                int returnVal = chooser.showOpenDialog(ViewerFrame.this);
                if (returnVal == 0) {
                    try {
                        Object obj = ViewerFrame.this.wrapper.restore(chooser.getSelectedFile());
                        if (!(obj instanceof Visible)) {
                            throw new RuntimeException(obj.getClass() + " is not Visible");
                        }
                        ViewerFrame.this.setContent(obj.getClass().toString(), ((Visible)obj).toGUI());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ViewerFrame.this, "Error opening " + chooser.getSelectedFile().getName() + ": " + ex, "Open File Error", 0);
                    }
                }
            }
        });
        this.saveItem = new JMenuItem("Save as ...");
        menu.add(this.saveItem);
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ViewerFrame.this.wrapper.isSaveable()) {
                    log.debug("Wrapper is saveable");
                    JFileChooser chooser = ViewerFrame.this.wrapper.makeFileChooser(ViewerFrame.this.wrapper);
                    int returnVal = chooser.showSaveDialog(ViewerFrame.this);
                    if (returnVal == 0) {
                        try {
                            FileFilter filter = chooser.getFileFilter();
                            String fmt = filter.getDescription();
                            String ext = ViewerFrame.this.wrapper.getExtensionFor(fmt);
                            File file0 = chooser.getSelectedFile();
                            File file = file0.getName().endsWith(ext) ? file0 : new File(file0.getParentFile(), file0.getName() + ext);
                            ViewerFrame.this.wrapper.saveAs(file, filter.getDescription());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(ViewerFrame.this, "Error saving: " + ex, "Save File Error", 0);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(ViewerFrame.this, "You cannot save " + ViewerFrame.this.content.getClass(), "Error", 0);
                }
            }
        });
        JMenuItem exitItem = new JMenuItem("Close");
        menu.add(exitItem);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ViewerFrame.this.dispose();
            }
        });
        JMenu menu2 = new JMenu("Go");
        menuBar.add(menu2);
        this.zoomItem = new JMenuItem("Zoom..");
        menu2.add(this.zoomItem);
        this.zoomItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                final JDialog dialog = new JDialog(ViewerFrame.this, "Subpanes to zoom into", true);
                JPanel pane = new JPanel();
                dialog.getContentPane().add(pane);
                ButtonGroup group = new ButtonGroup();
                final JRadioButton[] buttons = new JRadioButton[ViewerFrame.this.myViewer.getSubViewNames().size()];
                int k = 0;
                for (String name : ViewerFrame.this.myViewer.getSubViewNames()) {
                    JRadioButton button = new JRadioButton(name);
                    pane.add(button);
                    group.add(button);
                    buttons[k++] = button;
                }
                JButton launchButton = new JButton(new AbstractAction("Zoom"){
                    static final long serialVersionUID = 20080517L;

                    public void actionPerformed(ActionEvent ev) {
                        for (int i = 0; i < buttons.length; ++i) {
                            if (!buttons[i].isSelected()) continue;
                            String name = buttons[i].getText();
                            Viewer subview = ViewerFrame.this.myViewer.getNamedSubView(buttons[i].getText());
                            ViewerFrame.this.setContent(ViewerFrame.this.myName + " / " + name, subview);
                            dialog.dispose();
                        }
                    }
                });
                pane.add(launchButton);
                JButton cancelButton = new JButton(new AbstractAction("Cancel"){
                    static final long serialVersionUID = 20080517L;

                    public void actionPerformed(ActionEvent ev) {
                        dialog.dispose();
                    }
                });
                pane.add(cancelButton);
                dialog.setDefaultCloseOperation(0);
                dialog.pack();
                dialog.setLocationRelativeTo(ViewerFrame.this);
                dialog.setVisible(true);
            }
        });
    }

    public static void main(String[] args) {
        try {
            File file = new File(args[0]);
            Visible obj = (Visible)((Object)IOUtil.loadSerialized(file));
            if (!(obj instanceof Visible)) {
                System.out.println("Not visible object: " + obj.getClass());
            }
            new ViewerFrame(args[0], obj.toGUI());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("usage: ViewerFrame [serializedVisableObjectFile]");
        }
    }

    private static class ContentWrapper
    implements Saveable {
        private Object obj;
        private String[] formats;
        public static final String SERIALIZED_FORMAT_NAME = "Serialized Java Object";
        public static final String SERIALIZED_EXT = ".serialized";

        public ContentWrapper(Object obj) {
            this.obj = obj;
            int n = 0;
            if (obj instanceof Serializable) {
                n = 1;
            }
            if (obj instanceof Saveable) {
                String[] fs = ((Saveable)obj).getFormatNames();
                this.formats = new String[fs.length + n];
                for (int i = 0; i < fs.length; ++i) {
                    this.formats[i + n] = fs[i];
                }
            } else {
                this.formats = new String[n];
            }
            if (obj instanceof Serializable) {
                this.formats[0] = SERIALIZED_FORMAT_NAME;
            }
            log.debug("ContentWrapper for " + obj.getClass() + " has " + this.formats.length + " save format(s): " + StringUtil.toString(this.formats));
        }

        public boolean isSaveable() {
            return this.formats.length > 0;
        }

        public String[] getFormatNames() {
            return this.formats;
        }

        public String getExtensionFor(String formatName) {
            if (formatName.equals(SERIALIZED_FORMAT_NAME)) {
                return SERIALIZED_EXT;
            }
            if (this.obj instanceof Saveable) {
                return ((Saveable)this.obj).getExtensionFor(formatName);
            }
            return null;
        }

        public FileFilter getFilter(int i) {
            final String ext = this.getExtensionFor(this.formats[i]);
            final String fmt = this.formats[i];
            return new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(ext);
                }

                public String getDescription() {
                    return fmt;
                }
            };
        }

        public void saveAs(File file, String formatName) throws IOException {
            if (!this.isSaveable()) {
                throw new IllegalArgumentException("can't save " + this.obj);
            }
            if (SERIALIZED_FORMAT_NAME.equals(formatName)) {
                IOUtil.saveSerialized((Serializable)this.obj, file);
            } else {
                ((Saveable)this.obj).saveAs(file, formatName);
            }
        }

        public Object restore(File file) throws IOException {
            if (!this.isSaveable()) {
                throw new IllegalArgumentException("can't restore something like " + this.obj);
            }
            if (file.getName().endsWith(SERIALIZED_EXT)) {
                return IOUtil.loadSerialized(file);
            }
            return ((Saveable)this.obj).restore(file);
        }

        public JFileChooser makeFileChooser(ContentWrapper w) {
            JFileChooser chooser = new JFileChooser();
            for (int i = 0; i < this.formats.length; ++i) {
                chooser.addChoosableFileFilter(w.getFilter(i));
            }
            return chooser;
        }
    }
}

