/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.impl.Former;
import cern.colt.matrix.impl.FormerFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.BinFunctions1D;

public class Converter {
    public double[] edges(IAxis iAxis) {
        int n = iAxis.bins();
        double[] dArray = new double[n + 1];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = iAxis.binLowerEdge(n2);
            ++n2;
        }
        dArray[n] = iAxis.upperEdge();
        return dArray;
    }

    String form(Former former, double d) {
        return former.form(d);
    }

    protected double[] toArrayErrors(IHistogram1D iHistogram1D) {
        int n = iHistogram1D.xAxis().bins();
        double[] dArray = new double[n];
        int n2 = n;
        while (--n2 >= 0) {
            dArray[n2] = iHistogram1D.binError(n2);
        }
        return dArray;
    }

    protected double[][] toArrayErrors(IHistogram2D iHistogram2D) {
        int n = iHistogram2D.xAxis().bins();
        int n2 = iHistogram2D.yAxis().bins();
        double[][] dArray = new double[n][n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                dArray[n4][n3] = iHistogram2D.binError(n4, n3);
            }
        }
        return dArray;
    }

    protected double[] toArrayHeights(IHistogram1D iHistogram1D) {
        int n = iHistogram1D.xAxis().bins();
        double[] dArray = new double[n];
        int n2 = n;
        while (--n2 >= 0) {
            dArray[n2] = iHistogram1D.binHeight(n2);
        }
        return dArray;
    }

    protected double[][] toArrayHeights(IHistogram2D iHistogram2D) {
        int n = iHistogram2D.xAxis().bins();
        int n2 = iHistogram2D.yAxis().bins();
        double[][] dArray = new double[n][n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                dArray[n4][n3] = iHistogram2D.binHeight(n4, n3);
            }
        }
        return dArray;
    }

    protected double[][][] toArrayHeights(IHistogram3D iHistogram3D) {
        int n = iHistogram3D.xAxis().bins();
        int n2 = iHistogram3D.yAxis().bins();
        int n3 = iHistogram3D.zAxis().bins();
        double[][][] dArray = new double[n][n2][n3];
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                int n6 = n3;
                while (--n6 >= 0) {
                    dArray[n4][n5][n6] = iHistogram3D.binHeight(n4, n5, n6);
                }
            }
        }
        return dArray;
    }

    protected static String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = dArray.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(dArray[n2]);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString(IAxis iAxis) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Range: [" + iAxis.lowerEdge() + "," + iAxis.upperEdge() + ")");
        stringBuffer.append(", Bins: " + iAxis.bins());
        stringBuffer.append(", Bin edges: " + Converter.toString(this.edges(iAxis)) + "\n");
        return stringBuffer.toString();
    }

    public String toString(IHistogram1D iHistogram1D) {
        String string2 = null;
        String string3 = null;
        BinFunction1D[] binFunction1DArray = null;
        String string4 = "%G";
        Former former = new FormerFactory().create(string4);
        String string5 = System.getProperty("line.separator");
        int[] nArray = iHistogram1D.minMaxBins();
        String string6 = iHistogram1D.title() + ":" + string5 + "   Entries=" + this.form(former, iHistogram1D.entries()) + ", ExtraEntries=" + this.form(former, iHistogram1D.extraEntries()) + string5 + "   Mean=" + this.form(former, iHistogram1D.mean()) + ", Rms=" + this.form(former, iHistogram1D.rms()) + string5 + "   MinBinHeight=" + this.form(former, iHistogram1D.binHeight(nArray[0])) + ", MaxBinHeight=" + this.form(former, iHistogram1D.binHeight(nArray[1])) + string5 + "   Axis: " + "Bins=" + this.form(former, iHistogram1D.xAxis().bins()) + ", Min=" + this.form(former, iHistogram1D.xAxis().lowerEdge()) + ", Max=" + this.form(former, iHistogram1D.xAxis().upperEdge());
        String[] stringArray = new String[iHistogram1D.xAxis().bins()];
        int n = 0;
        while (n < iHistogram1D.xAxis().bins()) {
            stringArray[n] = this.form(former, iHistogram1D.xAxis().binLowerEdge(n));
            ++n;
        }
        String[] stringArray2 = null;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(1, iHistogram1D.xAxis().bins());
        denseDoubleMatrix2D.viewRow(0).assign(this.toArrayHeights(iHistogram1D));
        return string6 + string5 + "Heights:" + string5 + new Formatter().toTitleString(denseDoubleMatrix2D, stringArray2, stringArray, string3, string2, null, binFunction1DArray);
    }

    public String toString(IHistogram2D iHistogram2D) {
        String string2 = "X";
        String string3 = "Y";
        BinFunction1D[] binFunction1DArray = new BinFunction1D[]{BinFunctions1D.sum};
        String string4 = "%G";
        Former former = new FormerFactory().create(string4);
        String string5 = System.getProperty("line.separator");
        int[] nArray = iHistogram2D.minMaxBins();
        String string6 = iHistogram2D.title() + ":" + string5 + "   Entries=" + this.form(former, iHistogram2D.entries()) + ", ExtraEntries=" + this.form(former, iHistogram2D.extraEntries()) + string5 + "   MeanX=" + this.form(former, iHistogram2D.meanX()) + ", RmsX=" + this.form(former, iHistogram2D.rmsX()) + string5 + "   MeanY=" + this.form(former, iHistogram2D.meanY()) + ", RmsY=" + this.form(former, iHistogram2D.rmsX()) + string5 + "   MinBinHeight=" + this.form(former, iHistogram2D.binHeight(nArray[0], nArray[1])) + ", MaxBinHeight=" + this.form(former, iHistogram2D.binHeight(nArray[2], nArray[3])) + string5 + "   xAxis: " + "Bins=" + this.form(former, iHistogram2D.xAxis().bins()) + ", Min=" + this.form(former, iHistogram2D.xAxis().lowerEdge()) + ", Max=" + this.form(former, iHistogram2D.xAxis().upperEdge()) + string5 + "   yAxis: " + "Bins=" + this.form(former, iHistogram2D.yAxis().bins()) + ", Min=" + this.form(former, iHistogram2D.yAxis().lowerEdge()) + ", Max=" + this.form(former, iHistogram2D.yAxis().upperEdge());
        String[] stringArray = new String[iHistogram2D.xAxis().bins()];
        int n = 0;
        while (n < iHistogram2D.xAxis().bins()) {
            stringArray[n] = this.form(former, iHistogram2D.xAxis().binLowerEdge(n));
            ++n;
        }
        Object[] objectArray = new String[iHistogram2D.yAxis().bins()];
        int n2 = 0;
        while (n2 < iHistogram2D.yAxis().bins()) {
            objectArray[n2] = this.form(former, iHistogram2D.yAxis().binLowerEdge(n2));
            ++n2;
        }
        new ObjectArrayList(objectArray).reverse();
        DoubleMatrix2D doubleMatrix2D = new DenseDoubleMatrix2D(this.toArrayHeights(iHistogram2D));
        doubleMatrix2D = doubleMatrix2D.viewDice().viewRowFlip();
        return string6 + string5 + "Heights:" + string5 + new Formatter().toTitleString(doubleMatrix2D, (String[])objectArray, stringArray, string3, string2, null, binFunction1DArray);
    }

    public String toString(IHistogram3D iHistogram3D) {
        String string2 = "X";
        String string3 = "Y";
        String string4 = "Z";
        BinFunction1D[] binFunction1DArray = new BinFunction1D[]{BinFunctions1D.sum};
        String string5 = "%G";
        Former former = new FormerFactory().create(string5);
        String string6 = System.getProperty("line.separator");
        int[] nArray = iHistogram3D.minMaxBins();
        String string7 = iHistogram3D.title() + ":" + string6 + "   Entries=" + this.form(former, iHistogram3D.entries()) + ", ExtraEntries=" + this.form(former, iHistogram3D.extraEntries()) + string6 + "   MeanX=" + this.form(former, iHistogram3D.meanX()) + ", RmsX=" + this.form(former, iHistogram3D.rmsX()) + string6 + "   MeanY=" + this.form(former, iHistogram3D.meanY()) + ", RmsY=" + this.form(former, iHistogram3D.rmsX()) + string6 + "   MeanZ=" + this.form(former, iHistogram3D.meanZ()) + ", RmsZ=" + this.form(former, iHistogram3D.rmsZ()) + string6 + "   MinBinHeight=" + this.form(former, iHistogram3D.binHeight(nArray[0], nArray[1], nArray[2])) + ", MaxBinHeight=" + this.form(former, iHistogram3D.binHeight(nArray[3], nArray[4], nArray[5])) + string6 + "   xAxis: " + "Bins=" + this.form(former, iHistogram3D.xAxis().bins()) + ", Min=" + this.form(former, iHistogram3D.xAxis().lowerEdge()) + ", Max=" + this.form(former, iHistogram3D.xAxis().upperEdge()) + string6 + "   yAxis: " + "Bins=" + this.form(former, iHistogram3D.yAxis().bins()) + ", Min=" + this.form(former, iHistogram3D.yAxis().lowerEdge()) + ", Max=" + this.form(former, iHistogram3D.yAxis().upperEdge()) + string6 + "   zAxis: " + "Bins=" + this.form(former, iHistogram3D.zAxis().bins()) + ", Min=" + this.form(former, iHistogram3D.zAxis().lowerEdge()) + ", Max=" + this.form(former, iHistogram3D.zAxis().upperEdge());
        String[] stringArray = new String[iHistogram3D.xAxis().bins()];
        int n = 0;
        while (n < iHistogram3D.xAxis().bins()) {
            stringArray[n] = this.form(former, iHistogram3D.xAxis().binLowerEdge(n));
            ++n;
        }
        Object[] objectArray = new String[iHistogram3D.yAxis().bins()];
        int n2 = 0;
        while (n2 < iHistogram3D.yAxis().bins()) {
            objectArray[n2] = this.form(former, iHistogram3D.yAxis().binLowerEdge(n2));
            ++n2;
        }
        new ObjectArrayList(objectArray).reverse();
        Object[] objectArray2 = new String[iHistogram3D.zAxis().bins()];
        int n3 = 0;
        while (n3 < iHistogram3D.zAxis().bins()) {
            objectArray2[n3] = this.form(former, iHistogram3D.zAxis().binLowerEdge(n3));
            ++n3;
        }
        new ObjectArrayList(objectArray2).reverse();
        DoubleMatrix3D doubleMatrix3D = new DenseDoubleMatrix3D(this.toArrayHeights(iHistogram3D));
        doubleMatrix3D = doubleMatrix3D.viewDice(2, 1, 0).viewSliceFlip().viewRowFlip();
        return string7 + string6 + "Heights:" + string6 + new Formatter().toTitleString(doubleMatrix3D, (String[])objectArray2, (String[])objectArray, stringArray, string4, string3, string2, "", binFunction1DArray);
    }

    public String toXML(IHistogram1D iHistogram1D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        stringBuffer.append(string2);
        stringBuffer.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        stringBuffer.append(string2);
        stringBuffer.append("<plotML>");
        stringBuffer.append(string2);
        stringBuffer.append("<plot>");
        stringBuffer.append(string2);
        stringBuffer.append("<dataArea>");
        stringBuffer.append(string2);
        stringBuffer.append("<data1d>");
        stringBuffer.append(string2);
        stringBuffer.append("<bins1d title=\"" + iHistogram1D.title() + "\">");
        stringBuffer.append(string2);
        int n = 0;
        while (n < iHistogram1D.xAxis().bins()) {
            stringBuffer.append(iHistogram1D.binEntries(n) + "," + iHistogram1D.binError(n));
            stringBuffer.append(string2);
            ++n;
        }
        stringBuffer.append("</bins1d>");
        stringBuffer.append(string2);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
        stringBuffer.append(" min=\"" + iHistogram1D.xAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + iHistogram1D.xAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + iHistogram1D.xAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string2);
        stringBuffer.append("<statistics>");
        stringBuffer.append(string2);
        stringBuffer.append("<statistic name=\"Entries\" value=\"" + iHistogram1D.entries() + "\"/>");
        stringBuffer.append(string2);
        stringBuffer.append("<statistic name=\"Underflow\" value=\"" + iHistogram1D.binEntries(-2) + "\"/>");
        stringBuffer.append(string2);
        stringBuffer.append("<statistic name=\"Overflow\" value=\"" + iHistogram1D.binEntries(-1) + "\"/>");
        stringBuffer.append(string2);
        if (!Double.isNaN(iHistogram1D.mean())) {
            stringBuffer.append("<statistic name=\"Mean\" value=\"" + iHistogram1D.mean() + "\"/>");
            stringBuffer.append(string2);
        }
        if (!Double.isNaN(iHistogram1D.rms())) {
            stringBuffer.append("<statistic name=\"RMS\" value=\"" + iHistogram1D.rms() + "\"/>");
            stringBuffer.append(string2);
        }
        stringBuffer.append("</statistics>");
        stringBuffer.append(string2);
        stringBuffer.append("</data1d>");
        stringBuffer.append(string2);
        stringBuffer.append("</dataArea>");
        stringBuffer.append(string2);
        stringBuffer.append("</plot>");
        stringBuffer.append(string2);
        stringBuffer.append("</plotML>");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public String toXML(IHistogram2D iHistogram2D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        stringBuffer.append(string2);
        stringBuffer.append("<!DOCTYPE plotML SYSTEM \"plotML.dtd\">");
        stringBuffer.append(string2);
        stringBuffer.append("<plotML>");
        stringBuffer.append(string2);
        stringBuffer.append("<plot>");
        stringBuffer.append(string2);
        stringBuffer.append("<dataArea>");
        stringBuffer.append(string2);
        stringBuffer.append("<data2d type=\"xxx\">");
        stringBuffer.append(string2);
        stringBuffer.append("<bins2d title=\"" + iHistogram2D.title() + "\" xSize=\"" + iHistogram2D.xAxis().bins() + "\" ySize=\"" + iHistogram2D.yAxis().bins() + "\">");
        stringBuffer.append(string2);
        int n = 0;
        while (n < iHistogram2D.xAxis().bins()) {
            int n2 = 0;
            while (n2 < iHistogram2D.yAxis().bins()) {
                stringBuffer.append(iHistogram2D.binEntries(n, n2) + "," + iHistogram2D.binError(n, n2));
                stringBuffer.append(string2);
                ++n2;
            }
            ++n;
        }
        stringBuffer.append("</bins2d>");
        stringBuffer.append(string2);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"x0\"");
        stringBuffer.append(" min=\"" + iHistogram2D.xAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + iHistogram2D.xAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + iHistogram2D.xAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string2);
        stringBuffer.append("<binnedDataAxisAttributes type=\"double\" axis=\"y0\"");
        stringBuffer.append(" min=\"" + iHistogram2D.yAxis().lowerEdge() + "\"");
        stringBuffer.append(" max=\"" + iHistogram2D.yAxis().upperEdge() + "\"");
        stringBuffer.append(" numberOfBins=\"" + iHistogram2D.yAxis().bins() + "\"");
        stringBuffer.append("/>");
        stringBuffer.append(string2);
        stringBuffer.append("</data2d>");
        stringBuffer.append(string2);
        stringBuffer.append("</dataArea>");
        stringBuffer.append(string2);
        stringBuffer.append("</plot>");
        stringBuffer.append(string2);
        stringBuffer.append("</plotML>");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

