/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import iitb.CRF.EdgeGenerator;
import java.util.TreeSet;

public class RobustMath {
    public static double LOG0 = -1.7976931348623157E308;
    public static double LOG2 = 0.69314718055;
    static final double MINUS_LOG_EPSILON = 30.0;
    public static LogSumExp logSumExpFunc = new LogSumExp();
    static LogMult logMult = new LogMult();

    public static double logSumExp(double v1, double v2) {
        if (Math.abs(v1 - v2) < Double.MIN_VALUE) {
            return v1 + LOG2;
        }
        double vmin = Math.min(v1, v2);
        double vmax = Math.max(v1, v2);
        if (vmax > vmin + 30.0) {
            return vmax;
        }
        return vmax + LogExpCache.lookupAdd(vmax - vmin);
    }

    static void addNoDups(TreeSet vec, double v) {
        Double val = new Double(v);
        if (!vec.add(val)) {
            vec.remove(val);
            RobustMath.addNoDups(vec, val + LOG2);
        }
    }

    public static double logSumExp(TreeSet logProbVector) {
        while (logProbVector.size() > 1) {
            double lp0 = (Double)logProbVector.first();
            logProbVector.remove(logProbVector.first());
            double lp1 = (Double)logProbVector.first();
            logProbVector.remove(logProbVector.first());
            RobustMath.addNoDups(logProbVector, RobustMath.logSumExp(lp0, lp1));
        }
        if (logProbVector.size() > 0) {
            return (Double)logProbVector.first();
        }
        return LOG0;
    }

    static double logSumExp(DoubleMatrix1D logProb) {
        TreeSet logProbVector = new TreeSet();
        for (int lpx = 0; lpx < logProb.size(); ++lpx) {
            if (logProb.getQuick(lpx) == LOG0) continue;
            RobustMath.addNoDups(logProbVector, logProb.getQuick(lpx));
        }
        return RobustMath.logSumExp(logProbVector);
    }

    static void logSumExp(DoubleMatrix1D v1, DoubleMatrix1D v2) {
        for (int i = 0; i < v1.size(); ++i) {
            v1.set(i, RobustMath.logSumExp(v1.get(i), v2.get(i)));
        }
    }

    public static DoubleMatrix1D logMult(DoubleMatrix2D M, DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA) {
        double lalpha = 0.0;
        if (alpha != 1.0) {
            lalpha = Math.log(alpha);
        }
        if (beta != 0.0) {
            if (beta != 1.0) {
                double lbeta = Math.log(beta);
                for (int i = 0; i < z.size(); ++i) {
                    z.set(i, z.get(i) + lbeta);
                }
            }
        } else {
            z.assign(LOG0);
        }
        RobustMath.logMult.M = M;
        RobustMath.logMult.z = z;
        RobustMath.logMult.lalpha = lalpha;
        RobustMath.logMult.transposeA = transposeA;
        RobustMath.logMult.y = y;
        M.forEachNonZero(logMult);
        return z;
    }

    static DoubleMatrix1D logMult(DoubleMatrix2D M, DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA, EdgeGenerator edgeGen) {
        double lalpha = 0.0;
        if (alpha != 1.0) {
            lalpha = Math.log(alpha);
        }
        if (beta != 0.0) {
            if (beta != 1.0) {
                for (int i = 0; i < z.size(); ++i) {
                    z.set(i, z.get(i) + Math.log(beta));
                }
            }
        } else {
            z.assign(LOG0);
        }
        for (int j = 0; j < M.columns(); ++j) {
            int i = edgeGen.first(j);
            while (i < M.rows()) {
                int r = i;
                int c = j;
                if (transposeA) {
                    r = j;
                    c = i;
                }
                z.setQuick(r, RobustMath.logSumExp(z.getQuick(r), M.getQuick(i, j) + y.get(c) + lalpha));
                i = edgeGen.next(j, i);
            }
        }
        return z;
    }

    static DoubleMatrix1D Mult(DoubleMatrix2D M, DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA, EdgeGenerator edgeGen) {
        for (int i = 0; i < z.size(); ++i) {
            z.set(i, z.get(i) * beta);
        }
        for (int j = 0; j < M.columns(); ++j) {
            int i = edgeGen.first(j);
            while (i < M.rows()) {
                int r = i;
                int c = j;
                if (transposeA) {
                    r = j;
                    c = i;
                }
                z.set(r, z.getQuick(r) + M.getQuick(i, j) * y.getQuick(c) * alpha);
                i = edgeGen.next(j, i);
            }
        }
        return z;
    }

    public static void main(String[] args) {
        System.out.println(RobustMath.logSumExp(Double.parseDouble(args[0]), Double.parseDouble(args[1])));
    }

    public static double exp(double d) {
        if (Double.isInfinite(d) || d < 0.0 && Math.abs(d) > 30.0) {
            return 0.0;
        }
        return Math.exp(d);
    }

    public static double log(float val) {
        return (double)Math.abs(val - 1.0f) < Double.MIN_VALUE ? 0.0 : Math.log(val);
    }

    static class LogMult
    implements IntIntDoubleFunction {
        DoubleMatrix2D M;
        DoubleMatrix1D z;
        double lalpha;
        boolean transposeA;
        DoubleMatrix1D y;

        LogMult() {
        }

        public double apply(int i, int j, double val) {
            int r = i;
            int c = j;
            if (this.transposeA) {
                r = j;
                c = i;
            }
            this.z.set(r, RobustMath.logSumExp(this.z.get(r), this.M.get(i, j) + this.y.get(c) + this.lalpha));
            return val;
        }
    }

    static class LogSumExp
    implements DoubleDoubleFunction {
        LogSumExp() {
        }

        public double apply(double v1, double v2) {
            return RobustMath.logSumExp(v1, v2);
        }
    }

    static class LogExpCache {
        static int CUT_OFF = 6;
        static int NUM_FINE = 10000;
        static int NUM_COARSE = 1000;
        static boolean useCache = true;
        static double[] vals = new double[CUT_OFF * NUM_FINE + (30 - CUT_OFF) * NUM_COARSE + 1];

        LogExpCache() {
        }

        static double lookupAdd(double val) {
            if (!useCache) {
                return Math.log(Math.exp(-1.0 * val) + 1.0);
            }
            int index = 0;
            index = val < (double)CUT_OFF ? (int)Math.rint(val * (double)NUM_FINE) : NUM_FINE * CUT_OFF + (int)Math.rint((val - (double)CUT_OFF) * (double)NUM_COARSE);
            if (vals[index] < 0.0) {
                LogExpCache.vals[index] = Math.log(Math.exp(-1.0 * val) + 1.0);
            }
            return vals[index];
        }

        static {
            int i = vals.length - 1;
            while (i >= 0) {
                LogExpCache.vals[i--] = -1.0;
            }
        }
    }
}

