/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import iitb.Utils.Counters;

public class EdgeHistFeatures
extends FeatureTypes {
    String fname;
    String[] labelNames;
    int histsize;
    Counters ctr;
    boolean allDone;
    int[] histArr;

    public EdgeHistFeatures(FeatureGenImpl m, String name, String[] labels, int histsize) {
        super(m);
        this.fname = name;
        this.labelNames = labels;
        this.ctr = new Counters(histsize + 1, m.numStates());
        this.histsize = histsize;
        this.histArr = new int[histsize];
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        this.ctr.clear();
        this.allDone = false;
        if (pos < this.histsize) {
            this.allDone = true;
        }
        return this.allDone;
    }

    public boolean hasNext() {
        return this.histsize > 1 && !this.allDone;
    }

    public void next(FeatureImpl f) {
        f.ystart = this.ctr.value(1, 1);
        f.yend = this.ctr.value(0, 0);
        this.ctr.arrayCopy(this.histsize - 1, 1, this.histArr);
        f.historyArray = this.histArr;
        f.val = 1.0f;
        this.allDone = !this.ctr.advance();
        String name = "";
        for (int i = 0; i < this.histArr.length; ++i) {
            if (this.histArr[i] == -1) continue;
            if (this.labelNames == null) {
                name = name + this.ctr.value(this.histsize - 1, 1);
                continue;
            }
            int index = i + 1;
            name = name + this.fname + "." + index + "." + this.labelNames[this.model.label(f.ystart)];
        }
        this.setFeatureIdentifier(this.ctr.value(this.histsize - 1, 0), this.model.label(f.yend), name, f);
    }
}

