/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.Model;
import java.io.Serializable;

public abstract class FeatureTypes
implements Serializable {
    int thisTypeId;
    private FeatureGenImpl fgen;
    public Model model;

    public FeatureTypes(FeatureGenImpl fgen) {
        this.model = fgen.model;
        this.fgen = fgen;
        this.thisTypeId = fgen.numFeatureTypes++;
    }

    public FeatureTypes(FeatureTypes s) {
        this(s.fgen);
        this.thisTypeId = s.thisTypeId;
        --this.fgen.numFeatureTypes;
    }

    public boolean requiresTraining() {
        return false;
    }

    public void train(DataSequence data, int pos) {
    }

    public boolean startScanFeaturesAt(DataSequence data, int pos) {
        return this.startScanFeaturesAt(data, pos - 1, pos);
    }

    public abstract boolean startScanFeaturesAt(DataSequence var1, int var2, int var3);

    public abstract boolean hasNext();

    public abstract void next(FeatureImpl var1);

    public void setFeatureIdentifier(int fId, int stateId, String name, FeatureImpl f) {
        this.setFeatureIdentifier(fId, stateId, (Object)name, f);
    }

    public void setFeatureIdentifier(int fId, int stateId, Object name, FeatureImpl f) {
        f.strId.init(fId * this.fgen.numFeatureTypes + this.thisTypeId, stateId, name);
    }

    public void setFeatureIdentifier(int fId, FeatureImpl f) {
        f.strId.init(fId * this.fgen.numFeatureTypes + this.thisTypeId);
    }

    int labelIndependentId(FeatureImpl f) {
        return (f.strId.id - this.thisTypeId - f.strId.stateId * this.fgen.numFeatureTypes) / this.model.numStates() + this.thisTypeId;
    }

    int offsetLabelIndependentId(FeatureImpl f) {
        return (this.labelIndependentId(f) - this.thisTypeId) / this.fgen.numFeatureTypes;
    }

    public static int featureTypeId(FeatureImpl f, FeatureGenImpl fgen) {
        return f.strId.id % fgen.numFeatureTypes;
    }

    public void print(FeatureGenImpl.FeatureMap strToInt, double[] crfWs) {
    }

    public int maxFeatureId() {
        return Integer.MAX_VALUE;
    }

    public int getTypeId() {
        return this.thisTypeId;
    }

    public boolean featureCollectMode() {
        return this.fgen.featureCollectMode;
    }

    public boolean fixedTransitionFeatures() {
        return true;
    }
}

