/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;

public class FeatureTypesPosition
extends FeatureTypes {
    FeatureTypes ftype;
    boolean squareSent;
    int segStart;
    int segEnd;
    int currPos;
    FeatureImpl savedFeature = new FeatureImpl();
    int dataLen;
    transient DataSequence dataSeq;

    public FeatureTypesPosition(FeatureGenImpl fgen, FeatureTypes ftype) {
        super(fgen);
        this.ftype = ftype;
    }

    void advance() {
        while (!this.ftype.hasNext()) {
            ++this.currPos;
            if (this.currPos > this.segEnd) {
                return;
            }
            this.ftype.startScanFeaturesAt(this.dataSeq, this.currPos - 1, this.currPos);
        }
        return;
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        this.segStart = prevPos + 1;
        this.segEnd = pos;
        this.currPos = prevPos + 1;
        this.squareSent = true;
        this.dataSeq = data;
        this.dataLen = data.length();
        this.ftype.startScanFeaturesAt(data, prevPos, prevPos + 1);
        this.advance();
        return this.ftype.hasNext();
    }

    public boolean hasNext() {
        return !this.squareSent || this.currPos <= this.segEnd && this.ftype.hasNext();
    }

    public void next(FeatureImpl f) {
        if (!this.squareSent) {
            this.squareSent = true;
            f.copy(this.savedFeature);
            f.val *= f.val;
            this.advance();
            String name = "";
            if (this.featureCollectMode()) {
                name = "POS^2" + f.strId.name;
            }
            this.setFeatureIdentifier(f.strId.id * 2 + 1, f.strId.stateId, name, f);
        } else {
            this.ftype.next(f);
            f.val = (float)(this.currPos - this.segStart + 1) / (float)(this.segEnd - this.segStart + 1);
            this.savedFeature.copy(f);
            this.squareSent = false;
            int bin = (int)(f.val * 10.0f);
            int fid = f.strId.id;
            String name = "";
            if (this.featureCollectMode()) {
                name = "POS_" + f.strId.name;
            }
            this.setFeatureIdentifier(fid, f.strId.stateId, name, f);
        }
    }

    public boolean requiresTraining() {
        return this.ftype.requiresTraining();
    }

    public void train(DataSequence data, int pos) {
        this.ftype.train(data, pos);
    }

    int labelIndependentId(FeatureImpl f) {
        return this.ftype.labelIndependentId(f);
    }

    public int maxFeatureId() {
        return this.ftype.maxFeatureId() * 2;
    }
}

