/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;

public class FeatureTypesSegmentLength
extends FeatureTypes {
    protected int segLen;
    protected int maxLen = Integer.MAX_VALUE;

    public FeatureTypesSegmentLength(FeatureGenImpl m) {
        super(m);
    }

    public FeatureTypesSegmentLength(FeatureGenImpl m, int maxSegLen) {
        super(m);
        this.maxLen = maxSegLen;
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        this.segLen = Math.min(pos - prevPos, this.maxLen);
        return true;
    }

    public boolean hasNext() {
        return this.segLen > 0;
    }

    public void next(FeatureImpl f) {
        f.val = 1.0f;
        f.ystart = -1;
        if (this.featureCollectMode()) {
            f.strId.init(this.segLen, 0, "Length" + (this.segLen == this.maxLen ? ">=" : "=") + this.segLen);
        } else {
            f.strId.init(this.segLen);
        }
        this.segLen = 0;
    }
}

