/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import gnu.trove.TIntArrayList;
import iitb.CRF.DataSequence;
import iitb.CRF.SegmentDataSequence;
import iitb.Model.Edge;
import iitb.Model.EdgeIterator;
import iitb.Model.GenericModel;
import iitb.Model.Model;
import java.util.StringTokenizer;

public class NestedModel
extends Model {
    int _numStates;
    int _numEdges;
    int[] nodeOffsets;
    Model[] inner;
    Model outer;
    int[] startStates;
    int[] endStates;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NestedModel(int num, String specs) throws Exception {
        super(num);
        int i;
        this.name = "Nested";
        this.nodeOffsets = new int[this.numLabels];
        this.inner = new Model[this.numLabels];
        StringTokenizer start = new StringTokenizer(specs, ",");
        if (!$assertionsDisabled && !start.hasMoreTokens()) {
            throw new AssertionError();
        }
        this.outer = Model.getNewBaseModel(this.numLabels, start.nextToken());
        String commonStruct = null;
        for (int i2 = 0; i2 < this.numLabels; ++i2) {
            String thisStruct = commonStruct;
            if (thisStruct == null) {
                if (!$assertionsDisabled && !start.hasMoreTokens()) {
                    throw new AssertionError();
                }
                thisStruct = start.nextToken();
                if (thisStruct.endsWith("*")) {
                    commonStruct = thisStruct = thisStruct.substring(0, thisStruct.length() - 1);
                }
            }
            this.inner[i2] = new GenericModel(thisStruct, i2);
        }
        this._numEdges = 0;
        this._numStates = 0;
        for (int l = 0; l < this.numLabels; ++l) {
            int n = l;
            this.nodeOffsets[n] = this.nodeOffsets[n] + this._numStates;
            this._numStates += this.inner[l].numStates();
            this._numEdges += this.inner[l].numEdges();
        }
        EdgeIterator outerIter = this.outer.edgeIterator();
        while (outerIter.hasNext()) {
            Edge e = outerIter.next();
            this._numEdges += this.inner[e.end].numStartStates() * this.inner[e.start].numEndStates();
        }
        int numStart = 0;
        for (int i3 = 0; i3 < this.outer.numStartStates(); ++i3) {
            numStart += this.inner[this.outer.startState(i3)].numStartStates();
        }
        this.startStates = new int[numStart];
        int index = 0;
        for (int i4 = 0; i4 < this.outer.numStartStates(); ++i4) {
            for (int j = 0; j < this.inner[this.outer.startState(i4)].numStartStates(); ++j) {
                this.startStates[index++] = this.inner[this.outer.startState(i4)].startState(j) + this.nodeOffsets[this.outer.startState(i4)];
            }
        }
        int numEnd = 0;
        for (i = 0; i < this.outer.numEndStates(); ++i) {
            numEnd += this.inner[this.outer.endState(i)].numEndStates();
        }
        this.endStates = new int[numEnd];
        index = 0;
        for (i = 0; i < this.outer.numEndStates(); ++i) {
            for (int j = 0; j < this.inner[this.outer.endState(i)].numEndStates(); ++j) {
                this.endStates[index++] = this.inner[this.outer.endState(i)].endState(j) + this.nodeOffsets[this.outer.endState(i)];
            }
        }
    }

    public int numStates() {
        return this._numStates;
    }

    public int numEdges() {
        return this._numEdges;
    }

    public int label(int stateNum) {
        if (!($assertionsDisabled || stateNum >= 0 && stateNum < this.numStates())) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.nodeOffsets.length; ++i) {
            if (stateNum >= this.nodeOffsets[i]) continue;
            return i - 1;
        }
        return this.nodeOffsets.length - 1;
    }

    public int numStartStates() {
        return this.startStates.length;
    }

    public int numEndStates() {
        return this.endStates.length;
    }

    public int startState(int i) {
        return i < this.numStartStates() ? this.startStates[i] : -1;
    }

    public int endState(int i) {
        return i < this.numEndStates() ? this.endStates[i] : -1;
    }

    public boolean isEndState(int i) {
        for (int k = 0; k < this.endStates.length; ++k) {
            if (this.endStates[k] != i) continue;
            return true;
        }
        return false;
    }

    public boolean isStartState(int i) {
        for (int k = 0; k < this.startStates.length; ++k) {
            if (this.startStates[k] != i) continue;
            return true;
        }
        return false;
    }

    public void stateMappings(DataSequence data, int len, int start) throws Exception {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void stateMappings(SegmentDataSequence data) throws Exception {
        if (data.length() == 0) {
            return;
        }
        int lstart = 0;
        while (lstart < data.length()) {
            int lend = data.getSegmentEnd(lstart) + 1;
            if (lend == 0) {
                throw new Exception("Invalid segment end value");
            }
            int label = data.y(lstart);
            this.inner[label].stateMappings(data, lend - lstart, lstart);
            for (int k = lstart; k < lend; ++k) {
                data.set_y(k, this.nodeOffsets[label] + data.y(k));
            }
            lstart = lend;
        }
    }

    public void stateMappings(DataSequence data) throws Exception {
        if (data.length() == 0) {
            return;
        }
        int lstart = 0;
        while (lstart < data.length()) {
            int lend;
            for (lend = lstart + 1; lend < data.length() && data.y(lend) == data.y(lstart); ++lend) {
            }
            int label = data.y(lstart);
            this.inner[label].stateMappings(data, lend - lstart, lstart);
            for (int k = lstart; k < lend; ++k) {
                data.set_y(k, this.nodeOffsets[label] + data.y(k));
            }
            lstart = lend;
        }
    }

    public int stateMappingGivenLength(int label, int len, int posFromStart) throws Exception {
        return this.inner[label].stateMappingGivenLength(label, len, posFromStart) + this.nodeOffsets[label];
    }

    public void stateMappingGivenLength(int label, int len, TIntArrayList stateIds) throws Exception {
        this.inner[label].stateMappingGivenLength(label, len, stateIds);
        for (int i = stateIds.size() - 1; i >= 0; --i) {
            stateIds.setQuick(i, stateIds.getQuick(i) + this.nodeOffsets[label]);
        }
    }

    public EdgeIterator edgeIterator() {
        return new NestedEdgeIterator(this);
    }

    public static void main(String[] args) {
        try {
            System.out.println(args[0]);
            System.out.println(args[1]);
            NestedModel model = new NestedModel(Integer.parseInt(args[0]), args[1]);
            System.out.println(((Model)model).numStates());
            System.out.println(((Model)model).numEdges());
            System.out.println(((Model)model).numStartStates());
            System.out.println(((Model)model).numEndStates());
            EdgeIterator edgeIter = ((Model)model).edgeIterator();
            int edgeNum = 0;
            while (edgeIter.hasNext()) {
                boolean edgeIsOuter = edgeIter.nextIsOuter();
                Edge e = edgeIter.next();
                System.out.println(e.start + "(" + ((Model)model).label(e.start) + ")" + " -> " + e.end + ":" + edgeIsOuter + ";");
                ++edgeNum;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public EdgeIterator innerEdgeIterator() {
        return new NestedEdgeIterator(this, false);
    }

    static {
        $assertionsDisabled = !NestedModel.class.desiredAssertionStatus();
    }

    public class NestedEdgeIterator
    implements EdgeIterator {
        NestedModel model;
        int label;
        Edge edge;
        EdgeIterator[] edgeIter;
        EdgeIterator outerEdgeIter;
        Edge outerEdge;
        boolean outerEdgesSent;
        int index1;
        int index2;
        boolean sendOuter;
        static final /* synthetic */ boolean $assertionsDisabled;

        NestedEdgeIterator(NestedModel m) {
            this(m, true);
        }

        NestedEdgeIterator(NestedModel m, boolean sendOuter) {
            this.model = m;
            this.edge = new Edge();
            this.edgeIter = new EdgeIterator[this.model.numLabels];
            for (int l = 0; l < this.model.numLabels; ++l) {
                this.edgeIter[l] = this.model.inner[l].edgeIterator();
            }
            this.outerEdgeIter = this.model.outer.edgeIterator();
            this.sendOuter = sendOuter;
            this.start();
        }

        public void start() {
            this.label = 0;
            for (int l = 0; l < this.model.numLabels; ++l) {
                this.edgeIter[l].start();
            }
            this.outerEdgeIter.start();
            this.outerEdge = this.outerEdgeIter.next();
            this.outerEdgesSent = this.outerEdge == null || !this.sendOuter;
            this.index2 = 0;
            this.index1 = 0;
        }

        public boolean hasNext() {
            return this.label < this.model.numLabels || !this.outerEdgesSent;
        }

        public Edge nextOuterEdge() {
            this.edge.start = this.model.inner[this.outerEdge.start].endState(this.index1) + this.model.nodeOffsets[this.outerEdge.start];
            this.edge.end = this.model.inner[this.outerEdge.end].startState(this.index2) + this.model.nodeOffsets[this.outerEdge.end];
            ++this.index2;
            if (this.index2 == this.model.inner[this.outerEdge.end].numStartStates()) {
                this.index2 = 0;
                ++this.index1;
                if (this.index1 == this.model.inner[this.outerEdge.start].numEndStates()) {
                    if (this.outerEdgeIter.hasNext()) {
                        this.outerEdge = this.outerEdgeIter.next();
                        this.index2 = 0;
                        this.index1 = 0;
                    } else {
                        this.outerEdgesSent = true;
                    }
                }
            }
            return this.edge;
        }

        public Edge nextInnerEdge() {
            Edge edgeToRet = this.edgeIter[this.label].next();
            this.edge.start = edgeToRet.start;
            this.edge.end = edgeToRet.end;
            if (!$assertionsDisabled && this.edge == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.model.nodeOffsets == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.label >= this.model.nodeOffsets.length) {
                throw new AssertionError();
            }
            this.edge.start += this.model.nodeOffsets[this.label];
            this.edge.end += this.model.nodeOffsets[this.label];
            if (!this.edgeIter[this.label].hasNext()) {
                ++this.label;
            }
            return this.edge;
        }

        public Edge next() {
            if (!this.nextIsOuter()) {
                return this.nextInnerEdge();
            }
            return this.nextOuterEdge();
        }

        public boolean nextIsOuter() {
            return this.label >= this.model.numLabels;
        }

        static {
            $assertionsDisabled = !(class$iitb$Model$NestedModel == null ? (class$iitb$Model$NestedModel = NestedModel.class$("iitb.Model.NestedModel")) : class$iitb$Model$NestedModel).desiredAssertionStatus();
        }
    }
}

