/*
 * Decompiled with CFR 0.152.
 */
package iitb.Segment;

import iitb.Segment.Preprocessor;
import iitb.Segment.TrainData;
import iitb.Segment.TrainRecord;

public class AlphaNumericPreprocessor
extends Preprocessor {
    public static String DIGIT = new String("DIGIT");

    public int getCode() {
        return 1;
    }

    public static String preprocess(String s) {
        if (AlphaNumericPreprocessor.isNumber(s)) {
            return DIGIT;
        }
        return s;
    }

    public static boolean isNumber(String s) {
        try {
            Integer i = Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static TrainData preprocess(TrainData tokens, int numLabels) {
        tokens.startScan();
        while (tokens.hasMoreRecords()) {
            TrainRecord tr = tokens.nextRecord();
            for (int s = 0; s < tr.numSegments(); ++s) {
                String[] words = tr.tokens(s);
                for (int j = 0; j < words.length; ++j) {
                    words[j] = AlphaNumericPreprocessor.preprocess(words[j]);
                }
            }
        }
        return tokens;
    }
}

