/*
 * Decompiled with CFR 0.152.
 */
package iitb.Utils;

import iitb.Utils.ConfigException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

public class Options
extends Properties {
    protected String[] args;
    public boolean appendValues = false;
    private static String[] noargs = new String[0];

    public static Options parse(String[] args) {
        Options o = new Options(args);
        return o;
    }

    public Options(Properties defaults, String[] args) {
        super(defaults);
        this.args = args;
        this.parse();
    }

    public Options(String[][] defaults, String[] args) {
        Properties def = new Properties();
        for (int i = 0; i < defaults.length; ++i) {
            if (defaults[i][1] == null) continue;
            def.put(defaults[i][0], defaults[i][1]);
        }
        this.defaults = def;
        this.args = args;
        this.parse();
    }

    public Options(String[] args) {
        this.args = args;
        this.parse();
    }

    public Options() {
    }

    public Options(String[][] defaults) {
        this(defaults, noargs);
    }

    public void parse() {
        this.parse(0);
    }

    public void parse(int startIndex) {
        String name = null;
        String value = null;
        int i = startIndex;
        if (this.args.length <= startIndex) {
            return;
        }
        if (this.args[startIndex].charAt(0) != '-') {
            try {
                FileInputStream file = new FileInputStream(this.args[0]);
                this.load(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        while (i < this.args.length) {
            String arg = this.args[i];
            if (arg.charAt(0) == '-') {
                this.add(name, value);
                value = null;
                name = null;
                if (arg.length() == 1) {
                    name = "-";
                    value = null;
                } else {
                    name = arg.substring(1);
                }
            } else {
                value = arg;
                this.add(name, value);
                value = null;
                name = null;
            }
            ++i;
        }
        this.add(name, value);
    }

    protected void add(String name, String valueNew) {
        if (name == null) {
            return;
        }
        if (valueNew == null) {
            valueNew = "";
        }
        if (this.appendValues && this.get(name) != null) {
            String value = (String)this.get(name);
            valueNew = value + " " + valueNew;
        }
        this.put(name, valueNew);
    }

    public void add(int startIndex, String[] args) {
        this.args = args;
        this.parse(startIndex);
    }

    public void print(PrintStream out) {
        TreeSet set = new TreeSet(new Comparator(){

            public int compare(Object a, Object b) {
                return ((String)a).compareTo((String)b);
            }
        });
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            set.add(o);
        }
        Iterator i = set.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String val = this.getProperty(key);
            out.println(key + " = " + val);
        }
    }

    public String getString(String key) {
        return this.getProperty(key);
    }

    public int getIntLoose(String key) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public double getDoubleLoose(String key) {
        try {
            return new Double(this.getProperty(key));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public int getInt(String key) throws ConfigException {
        try {
            if (this.getProperty(key) == null) {
                return 0;
            }
            return Integer.parseInt(this.getProperty(key));
        }
        catch (Exception e) {
            throw new ConfigException(key + " cannot parse to integer ");
        }
    }

    public double getDouble(String key) throws ConfigException {
        try {
            return new Double(this.getProperty(key));
        }
        catch (Exception e) {
            throw new ConfigException(key + " cannot parse to double ");
        }
    }

    public String getMandatoryProperty(String name) throws ConfigException {
        String ans = this.getProperty(name);
        if (ans == null) {
            throw new ConfigException(name + " not defined in config");
        }
        return ans;
    }

    public static void main(String[] args) {
        Options.parse(args).list(System.out);
    }
}

