/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.labels.PieItemLabelGenerator;
import org.jfree.data.PieDataset;
import org.jfree.util.ObjectUtils;

public class StandardPieItemLabelGenerator
implements PieItemLabelGenerator,
Cloneable,
Serializable {
    private NumberFormat numberFormat;

    public StandardPieItemLabelGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardPieItemLabelGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public String generateToolTip(PieDataset pieDataset, Comparable comparable, int n) {
        String string2 = null;
        Number number = pieDataset.getValue(comparable);
        if (number != null) {
            String string3 = comparable.toString();
            string2 = string3 + " = " + this.numberFormat.format(number);
        }
        return string2;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardPieItemLabelGenerator standardPieItemLabelGenerator = (StandardPieItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            standardPieItemLabelGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        return standardPieItemLabelGenerator;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardPieItemLabelGenerator) {
            StandardPieItemLabelGenerator standardPieItemLabelGenerator = (StandardPieItemLabelGenerator)object;
            return ObjectUtils.equal(this.numberFormat, standardPieItemLabelGenerator.getNumberFormat());
        }
        return false;
    }
}

