/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYDifferenceRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private transient Paint positivePaint;
    private transient Paint negativePaint;
    private boolean plotShapes = true;

    public XYDifferenceRenderer(Paint paint, Paint paint2, boolean bl) {
        this.positivePaint = paint;
        this.negativePaint = paint2;
        this.plotShapes = bl;
    }

    public int initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
        return 2;
    }

    public Paint getPositivePaint() {
        return this.positivePaint;
    }

    public Paint getNegativePaint() {
        return this.positivePaint;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        if (n3 == 0) {
            this.drawItemPass0(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo);
        } else if (n3 == 1) {
            this.drawItemPass1(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo);
        }
    }

    private void drawItemPass0(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        if (n == 0) {
            Number number = xYDataset.getYValue(0, n2);
            Number number2 = xYDataset.getXValue(1, n2);
            Number number3 = xYDataset.getYValue(1, n2);
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d = number.doubleValue();
            double d2 = valueAxis2.translateValueToJava2D(d, rectangle2D, rectangleEdge2);
            double d3 = number2.doubleValue();
            double d4 = number3.doubleValue();
            double d5 = valueAxis.translateValueToJava2D(d3, rectangle2D, rectangleEdge);
            double d6 = valueAxis2.translateValueToJava2D(d4, rectangle2D, rectangleEdge2);
            if (n2 > 0) {
                Shape shape;
                double d7;
                double d8;
                double d9;
                Number number4 = xYDataset.getXValue(0, n2 - 1);
                Number number5 = xYDataset.getYValue(0, n2 - 1);
                Number number6 = xYDataset.getYValue(1, n2 - 1);
                double d10 = number4.doubleValue();
                double d11 = number5.doubleValue();
                double d12 = valueAxis.translateValueToJava2D(d10, rectangle2D, rectangleEdge);
                Shape shape2 = this.getPositiveArea((float)d12, (float)(d9 = valueAxis2.translateValueToJava2D(d11, rectangle2D, rectangleEdge2)), (float)(d8 = valueAxis2.translateValueToJava2D(d7 = number6.doubleValue(), rectangle2D, rectangleEdge2)), (float)d5, (float)d2, (float)d6);
                if (shape2 != null) {
                    graphics2D.setPaint(this.positivePaint);
                    graphics2D.fill(shape2);
                }
                if ((shape = this.getNegativeArea((float)d12, (float)d9, (float)d8, (float)d5, (float)d2, (float)d6)) != null) {
                    graphics2D.setPaint(this.negativePaint);
                    graphics2D.fill(shape);
                }
            }
        }
    }

    private void drawItemPass1(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        Object object = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (n == 0) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Number number = xYDataset.getXValue(0, n2);
            Number number2 = xYDataset.getYValue(0, n2);
            Number number3 = xYDataset.getXValue(1, n2);
            Number number4 = xYDataset.getYValue(1, n2);
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d = number.doubleValue();
            double d2 = number2.doubleValue();
            double d3 = valueAxis.translateValueToJava2D(d, rectangle2D, rectangleEdge);
            double d4 = valueAxis2.translateValueToJava2D(d2, rectangle2D, rectangleEdge2);
            double d5 = number3.doubleValue();
            double d6 = number4.doubleValue();
            double d7 = valueAxis.translateValueToJava2D(d5, rectangle2D, rectangleEdge);
            double d8 = valueAxis2.translateValueToJava2D(d6, rectangle2D, rectangleEdge2);
            if (n2 > 0) {
                Line2D.Double double_;
                object5 = xYDataset.getXValue(0, n2 - 1);
                object4 = xYDataset.getYValue(0, n2 - 1);
                object3 = xYDataset.getXValue(1, n2 - 1);
                object2 = xYDataset.getYValue(1, n2 - 1);
                double d9 = ((Number)object5).doubleValue();
                double d10 = ((Number)object4).doubleValue();
                double d11 = valueAxis.translateValueToJava2D(d9, rectangle2D, rectangleEdge);
                double d12 = valueAxis2.translateValueToJava2D(d10, rectangle2D, rectangleEdge2);
                double d13 = ((Number)object3).doubleValue();
                double d14 = ((Number)object2).doubleValue();
                double d15 = valueAxis.translateValueToJava2D(d13, rectangle2D, rectangleEdge);
                double d16 = valueAxis2.translateValueToJava2D(d14, rectangle2D, rectangleEdge2);
                Line2D.Double double_2 = new Line2D.Double(d3, d4, d11, d12);
                if (double_2.intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                    graphics2D.draw(double_2);
                }
                if ((double_ = new Line2D.Double(d7, d8, d15, d16)).intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(1, n2));
                    graphics2D.draw(double_);
                }
            }
            if (this.plotShapes) {
                object5 = this.getItemShape(n, n2);
                if ((object5 = this.createTransformedShape((Shape)object5, d3, d4)).intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                    graphics2D.fill((Shape)object5);
                }
                object = object5;
                if (entityCollection != null) {
                    if (object == null) {
                        object = new Rectangle2D.Double(d3 - 2.0, d4 - 2.0, 4.0, 4.0);
                    }
                    object4 = null;
                    if (this.getToolTipGenerator() != null) {
                        object4 = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
                    }
                    object3 = null;
                    if (this.getURLGenerator() != null) {
                        object3 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                    }
                    object2 = new XYItemEntity((Shape)object, xYDataset, n, n2, (String)object4, (String)object3);
                    entityCollection.addEntity((ChartEntity)object2);
                }
                object4 = this.getItemShape(n + 1, n2);
                if ((object4 = this.createTransformedShape((Shape)object4, d7, d8)).intersects(rectangle2D)) {
                    graphics2D.setPaint(this.getItemPaint(n + 1, n2));
                    graphics2D.fill((Shape)object4);
                }
                object = object4;
                if (entityCollection != null) {
                    if (object == null) {
                        object = new Rectangle2D.Double(d7 - 2.0, d8 - 2.0, 4.0, 4.0);
                    }
                    object3 = null;
                    if (this.getToolTipGenerator() != null) {
                        object3 = this.getToolTipGenerator().generateToolTip(xYDataset, n + 1, n2);
                    }
                    object2 = null;
                    if (this.getURLGenerator() != null) {
                        object2 = this.getURLGenerator().generateURL(xYDataset, n + 1, n2);
                    }
                    XYItemEntity xYItemEntity = new XYItemEntity((Shape)object, xYDataset, n + 1, n2, (String)object3, (String)object2);
                    entityCollection.addEntity(xYItemEntity);
                }
            }
        }
    }

    private Shape getPositiveArea(float f, float f2, float f3, float f4, float f5, float f6) {
        GeneralPath generalPath = null;
        if (f2 >= f3) {
            if (!(f5 >= f6)) {
                float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.moveTo(f4, f5);
                generalPath2.lineTo(fArray[0], fArray[1]);
                generalPath2.lineTo(f4, f6);
                generalPath2.closePath();
                generalPath = generalPath2;
            }
        } else if (f5 >= f6) {
            float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
            GeneralPath generalPath3 = new GeneralPath();
            generalPath3.moveTo(f, f2);
            generalPath3.lineTo(fArray[0], fArray[1]);
            generalPath3.lineTo(f, f3);
            generalPath3.closePath();
            generalPath = generalPath3;
        } else {
            GeneralPath generalPath4 = new GeneralPath();
            generalPath4.moveTo(f, f2);
            generalPath4.lineTo(f4, f5);
            generalPath4.lineTo(f4, f6);
            generalPath4.lineTo(f, f3);
            generalPath4.closePath();
            generalPath = generalPath4;
        }
        return generalPath;
    }

    private Shape getNegativeArea(float f, float f2, float f3, float f4, float f5, float f6) {
        GeneralPath generalPath = null;
        if (f2 >= f3) {
            if (f5 >= f6) {
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.moveTo(f, f2);
                generalPath2.lineTo(f4, f5);
                generalPath2.lineTo(f4, f6);
                generalPath2.lineTo(f, f3);
                generalPath2.closePath();
                generalPath = generalPath2;
            } else {
                float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
                GeneralPath generalPath3 = new GeneralPath();
                generalPath3.moveTo(f, f2);
                generalPath3.lineTo(fArray[0], fArray[1]);
                generalPath3.lineTo(f, f3);
                generalPath3.closePath();
                generalPath = generalPath3;
            }
        } else if (f5 >= f6) {
            float[] fArray = this.getIntersection(f, f2, f4, f5, f, f3, f4, f6);
            GeneralPath generalPath4 = new GeneralPath();
            generalPath4.moveTo(f4, f5);
            generalPath4.lineTo(fArray[0], fArray[1]);
            generalPath4.lineTo(f4, f6);
            generalPath4.closePath();
            generalPath = generalPath4;
        }
        return generalPath;
    }

    private float[] getIntersection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = (f7 - f5) * (f2 - f6) - (f8 - f6) * (f - f5);
        float f10 = (f8 - f6) * (f3 - f) - (f7 - f5) * (f4 - f2);
        float f11 = f9 / f10;
        float[] fArray = new float[]{f + f11 * (f3 - f), f2 + f11 * (f4 - f2)};
        return fArray;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.positivePaint, objectOutputStream);
        SerialUtilities.writePaint(this.negativePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.positivePaint = SerialUtilities.readPaint(objectInputStream);
        this.negativePaint = SerialUtilities.readPaint(objectInputStream);
    }
}

