/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.servlet.ChartDeleter;

public class ServletUtilities {
    public static String saveChartAsPNG(JFreeChart jFreeChart, int n, int n2, HttpSession httpSession) throws IOException {
        return ServletUtilities.saveChartAsPNG(jFreeChart, n, n2, null, httpSession);
    }

    public static String saveChartAsPNG(JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, HttpSession httpSession) throws IOException {
        ServletUtilities.createTempDir();
        File file = File.createTempFile("jfreechart-", ".png", new File(System.getProperty("java.io.tmpdir")));
        ChartUtilities.saveChartAsPNG(file, jFreeChart, n, n2, chartRenderingInfo);
        ServletUtilities.registerChartForDeletion(file, httpSession);
        return file.getName();
    }

    public static String saveChartAsJPEG(JFreeChart jFreeChart, int n, int n2, HttpSession httpSession) throws IOException {
        return ServletUtilities.saveChartAsJPEG(jFreeChart, n, n2, null, httpSession);
    }

    public static String saveChartAsJPEG(JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, HttpSession httpSession) throws IOException {
        ServletUtilities.createTempDir();
        File file = File.createTempFile("jfreechart-", ".jpeg", new File(System.getProperty("java.io.tmpdir")));
        ChartUtilities.saveChartAsJPEG(file, jFreeChart, n, n2, chartRenderingInfo);
        ServletUtilities.registerChartForDeletion(file, httpSession);
        return file.getName();
    }

    protected static void createTempDir() {
        String string2 = System.getProperty("java.io.tmpdir");
        if (string2 == null) {
            throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null");
        }
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected static void registerChartForDeletion(File file, HttpSession httpSession) {
        if (httpSession != null) {
            ChartDeleter chartDeleter = (ChartDeleter)httpSession.getAttribute("JFreeChart_Deleter");
            if (chartDeleter == null) {
                chartDeleter = new ChartDeleter();
                httpSession.setAttribute("JFreeChart_Deleter", (Object)chartDeleter);
            }
            chartDeleter.addChart(file.getName());
        } else {
            System.out.println("Session is null - chart will not be deleted");
        }
    }

    public static void sendTempFile(String string2, HttpServletResponse httpServletResponse) throws IOException, FileNotFoundException {
        File file = new File(System.getProperty("java.io.tmpdir"), string2);
        ServletUtilities.sendTempFile(file, httpServletResponse);
    }

    public static void sendTempFile(File file, HttpServletResponse httpServletResponse) throws IOException, FileNotFoundException {
        String string2 = null;
        String string3 = file.getName();
        if (string3.length() > 5) {
            if (string3.substring(string3.length() - 5, string3.length()).equals(".jpeg")) {
                string2 = "image/jpeg";
            } else if (string3.substring(string3.length() - 4, string3.length()).equals(".png")) {
                string2 = "image/png";
            }
        }
        ServletUtilities.sendTempFile(file, httpServletResponse, string2);
    }

    public static void sendTempFile(File file, HttpServletResponse httpServletResponse, String string2) throws IOException, FileNotFoundException {
        BufferedOutputStream bufferedOutputStream;
        BufferedInputStream bufferedInputStream;
        if (file.exists()) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            if (string2 != null) {
                httpServletResponse.setHeader("Content-Type", string2);
            }
            httpServletResponse.setHeader("Content-Length", String.valueOf(file.length()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            httpServletResponse.setHeader("Last-Modified", simpleDateFormat.format(new Date(file.lastModified())));
            bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            byte[] byArray = new byte[1024];
            boolean bl = false;
            while (!bl) {
                int n = bufferedInputStream.read(byArray);
                if (n == -1) {
                    bl = true;
                    continue;
                }
                bufferedOutputStream.write(byArray, 0, n);
            }
        } else {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        bufferedOutputStream.flush();
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public static String searchReplace(String string2, String string3, String string4) {
        int n = string2.indexOf(string3);
        if (n == -1) {
            return string2;
        }
        String string5 = "";
        string5 = string5 + string2.substring(0, n) + string4;
        if (n + string3.length() < string2.length()) {
            string5 = string5 + ServletUtilities.searchReplace(string2.substring(n + string3.length()), string3, string4);
        }
        return string5;
    }
}

